/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.impl.util.ReflectUtil;
import org.flowable.engine.common.EngineInfo;
import org.flowable.engine.common.api.FlowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentEngines {
    private static Logger log = LoggerFactory.getLogger(ContentEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, ContentEngine> contentEngines;
    protected static Map<String, EngineInfo> contentEngineInfosByName;
    protected static Map<String, EngineInfo> contentEngineInfosByResourceUrl;
    protected static List<EngineInfo> contentEngineInfos;

    public static synchronized void init() {
        if (!ContentEngines.isInitialized()) {
            if (contentEngines == null) {
                contentEngines = new HashMap<String, ContentEngine>();
            }
            ClassLoader classLoader = ContentEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("flowable.content.cfg.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable.content.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                log.info("Initializing content engine using configuration '{}'", (Object)resource.toString());
                ContentEngines.initContentEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("flowable-content-context.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable-content-context.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                log.info("Initializing content engine using Spring configuration '{}'", (Object)resource.toString());
                ContentEngines.initContentEngineFromSpringResource(resource);
            }
            ContentEngines.setInitialized(true);
        } else {
            log.info("Content engines already initialized");
        }
    }

    protected static void initContentEngineFromSpringResource(URL resource) {
        try {
            Class<?> springConfigurationHelperClass = ReflectUtil.loadClass("org.flowable.content.spring.SpringContentConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildContentEngine", URL.class);
            ContentEngine contentEngine = (ContentEngine)method.invoke(null, resource);
            String contentEngineName = contentEngine.getName();
            EngineInfo contentEngineInfo = new EngineInfo(contentEngineName, resource.toString(), null);
            contentEngineInfosByName.put(contentEngineName, contentEngineInfo);
            contentEngineInfosByResourceUrl.put(resource.toString(), contentEngineInfo);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't initialize content engine from spring configuration resource " + resource.toString() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void registerContentEngine(ContentEngine contentEngine) {
        contentEngines.put(contentEngine.getName(), contentEngine);
    }

    public static void unregister(ContentEngine formEngine) {
        contentEngines.remove(formEngine.getName());
    }

    private static EngineInfo initContentEngineFromResource(URL resourceUrl) {
        EngineInfo contentEngineInfo = contentEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (contentEngineInfo != null) {
            contentEngineInfos.remove(contentEngineInfo);
            if (contentEngineInfo.getException() == null) {
                String contentEngineName = contentEngineInfo.getName();
                contentEngines.remove(contentEngineName);
                contentEngineInfosByName.remove(contentEngineName);
            }
            contentEngineInfosByResourceUrl.remove(contentEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            log.info("initializing content engine for resource {}", (Object)resourceUrl);
            ContentEngine contentEngine = ContentEngines.buildFormEngine(resourceUrl);
            String contentEngineName = contentEngine.getName();
            log.info("initialised content engine {}", (Object)contentEngineName);
            contentEngineInfo = new EngineInfo(contentEngineName, resourceUrlString, null);
            contentEngines.put(contentEngineName, contentEngine);
            contentEngineInfosByName.put(contentEngineName, contentEngineInfo);
        }
        catch (Throwable e) {
            log.error("Exception while initializing content engine: {}", (Object)e.getMessage(), (Object)e);
            contentEngineInfo = new EngineInfo(null, resourceUrlString, ContentEngines.getExceptionString(e));
        }
        contentEngineInfosByResourceUrl.put(resourceUrlString, contentEngineInfo);
        contentEngineInfos.add(contentEngineInfo);
        return contentEngineInfo;
    }

    private static String getExceptionString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    protected static ContentEngine buildFormEngine(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            ContentEngineConfiguration contentEngineConfiguration = ContentEngineConfiguration.createContentEngineConfigurationFromInputStream(inputStream);
            ContentEngine contentEngine = contentEngineConfiguration.buildContentEngine();
            return contentEngine;
        }
        catch (IOException e) {
            throw new FlowableException("couldn't open resource stream: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static List<EngineInfo> getContentEngineInfos() {
        return contentEngineInfos;
    }

    public static EngineInfo getContentEngineInfo(String contentEngineName) {
        return contentEngineInfosByName.get(contentEngineName);
    }

    public static ContentEngine getDefaultContentEngine() {
        return ContentEngines.getContentEngine(NAME_DEFAULT);
    }

    public static ContentEngine getContentEngine(String contentEngineName) {
        if (!ContentEngines.isInitialized()) {
            ContentEngines.init();
        }
        return contentEngines.get(contentEngineName);
    }

    public static EngineInfo retry(String resourceUrl) {
        log.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return ContentEngines.initContentEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("invalid url: " + resourceUrl, (Throwable)e);
        }
    }

    public static Map<String, ContentEngine> getContentEngines() {
        return contentEngines;
    }

    public static synchronized void destroy() {
        if (ContentEngines.isInitialized()) {
            HashMap<String, ContentEngine> engines = new HashMap<String, ContentEngine>(contentEngines);
            contentEngines = new HashMap<String, ContentEngine>();
            for (String contentEngineName : engines.keySet()) {
                ContentEngine contentEngine = (ContentEngine)engines.get(contentEngineName);
                try {
                    contentEngine.close();
                }
                catch (Exception e) {
                    log.error("exception while closing {}", (Object)(contentEngineName == null ? "the default content engine" : "content engine " + contentEngineName), (Object)e);
                }
            }
            contentEngineInfosByName.clear();
            contentEngineInfosByResourceUrl.clear();
            contentEngineInfos.clear();
            ContentEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        ContentEngines.isInitialized = isInitialized;
    }

    static {
        contentEngines = new HashMap<String, ContentEngine>();
        contentEngineInfosByName = new HashMap<String, EngineInfo>();
        contentEngineInfosByResourceUrl = new HashMap<String, EngineInfo>();
        contentEngineInfos = new ArrayList<EngineInfo>();
    }
}

