/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.flowable.content.api.ContentManagementService;
import org.flowable.content.api.ContentService;
import org.flowable.content.api.ContentStorage;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.impl.ContentEngineImpl;
import org.flowable.content.engine.impl.ContentManagementServiceImpl;
import org.flowable.content.engine.impl.ContentServiceImpl;
import org.flowable.content.engine.impl.ServiceImpl;
import org.flowable.content.engine.impl.cfg.CommandExecutorImpl;
import org.flowable.content.engine.impl.cfg.StandaloneContentEngineConfiguration;
import org.flowable.content.engine.impl.cfg.StandaloneInMemContentEngineConfiguration;
import org.flowable.content.engine.impl.cfg.TransactionListener;
import org.flowable.content.engine.impl.cfg.standalone.StandaloneMybatisTransactionContextFactory;
import org.flowable.content.engine.impl.db.DbSqlSessionFactory;
import org.flowable.content.engine.impl.fs.SimpleFileSystemContentStorage;
import org.flowable.content.engine.impl.interceptor.CommandContext;
import org.flowable.content.engine.impl.interceptor.CommandContextFactory;
import org.flowable.content.engine.impl.interceptor.CommandContextInterceptor;
import org.flowable.content.engine.impl.interceptor.CommandExecutor;
import org.flowable.content.engine.impl.interceptor.CommandInterceptor;
import org.flowable.content.engine.impl.interceptor.CommandInvoker;
import org.flowable.content.engine.impl.interceptor.LogInterceptor;
import org.flowable.content.engine.impl.interceptor.TransactionContextInterceptor;
import org.flowable.content.engine.impl.persistence.entity.ContentItemEntityManager;
import org.flowable.content.engine.impl.persistence.entity.ContentItemEntityManagerImpl;
import org.flowable.content.engine.impl.persistence.entity.TableDataManager;
import org.flowable.content.engine.impl.persistence.entity.TableDataManagerImpl;
import org.flowable.content.engine.impl.persistence.entity.data.ContentItemDataManager;
import org.flowable.content.engine.impl.persistence.entity.data.impl.MybatisContentItemDataManager;
import org.flowable.engine.common.AbstractEngineConfiguration;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.cfg.BeansConfigurationHelper;
import org.flowable.engine.common.impl.cfg.TransactionContextFactory;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.common.impl.interceptor.SessionFactory;
import org.flowable.engine.common.runtime.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentEngineConfiguration
extends AbstractEngineConfiguration {
    protected static final Logger logger = LoggerFactory.getLogger(ContentEngineConfiguration.class);
    public static final String DEFAULT_MYBATIS_MAPPING_FILE = "org/flowable/content/db/mapping/mappings.xml";
    public static final String LIQUIBASE_CHANGELOG_PREFIX = "ACT_CO_";
    protected String contentEngineName = "default";
    protected CommandInterceptor commandInvoker;
    protected List<CommandInterceptor> customPreCommandInterceptors;
    protected List<CommandInterceptor> customPostCommandInterceptors;
    protected List<CommandInterceptor> commandInterceptors;
    protected CommandExecutor commandExecutor;
    protected ContentManagementService contentManagementService = new ContentManagementServiceImpl();
    protected ContentService contentService = new ContentServiceImpl();
    protected ContentItemDataManager contentItemDataManager;
    protected ContentStorage contentStorage;
    protected String contentRootFolder;
    protected boolean createContentRootFolder = true;
    protected ContentItemEntityManager contentItemEntityManager;
    protected TableDataManager tableDataManager;
    protected CommandContextFactory commandContextFactory;
    protected TransactionContextFactory<TransactionListener, CommandContext> transactionContextFactory;
    protected DbSqlSessionFactory dbSqlSessionFactory;

    public static ContentEngineConfiguration createContentEngineConfigurationFromResourceDefault() {
        return ContentEngineConfiguration.createContentEngineConfigurationFromResource("flowable.content.cfg.xml", "contentEngineConfiguration");
    }

    public static ContentEngineConfiguration createContentEngineConfigurationFromResource(String resource) {
        return ContentEngineConfiguration.createContentEngineConfigurationFromResource(resource, "contentEngineConfiguration");
    }

    public static ContentEngineConfiguration createContentEngineConfigurationFromResource(String resource, String beanName) {
        return (ContentEngineConfiguration)BeansConfigurationHelper.parseEngineConfigurationFromResource((String)resource, (String)beanName);
    }

    public static ContentEngineConfiguration createContentEngineConfigurationFromInputStream(InputStream inputStream) {
        return ContentEngineConfiguration.createContentEngineConfigurationFromInputStream(inputStream, "contentEngineConfiguration");
    }

    public static ContentEngineConfiguration createContentEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        return (ContentEngineConfiguration)BeansConfigurationHelper.parseEngineConfigurationFromInputStream((InputStream)inputStream, (String)beanName);
    }

    public static ContentEngineConfiguration createStandaloneContentEngineConfiguration() {
        return new StandaloneContentEngineConfiguration();
    }

    public static ContentEngineConfiguration createStandaloneInMemContentEngineConfiguration() {
        return new StandaloneInMemContentEngineConfiguration();
    }

    public ContentEngine buildContentEngine() {
        this.init();
        return new ContentEngineImpl(this);
    }

    protected void init() {
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initIdGenerator();
        if (this.usingRelationalDatabase) {
            this.initDataSource();
            this.initDbSchema();
        }
        this.initBeans();
        this.initTransactionFactory();
        this.initSqlSessionFactory();
        this.initSessionFactories();
        this.initServices();
        this.initDataManagers();
        this.initEntityManagers();
        this.initContentStorage();
        this.initClock();
    }

    protected void initServices() {
        this.initService(this.contentManagementService);
        this.initService(this.contentService);
    }

    protected void initService(Object service) {
        if (service instanceof ServiceImpl) {
            ((ServiceImpl)service).setCommandExecutor(this.commandExecutor);
        }
    }

    public void initDataManagers() {
        if (this.contentItemDataManager == null) {
            this.contentItemDataManager = new MybatisContentItemDataManager(this);
        }
    }

    public void initEntityManagers() {
        if (this.contentItemEntityManager == null) {
            this.contentItemEntityManager = new ContentItemEntityManagerImpl(this, this.contentItemDataManager);
        }
        if (this.tableDataManager == null) {
            this.tableDataManager = new TableDataManagerImpl(this);
        }
    }

    public void initContentStorage() {
        if (this.contentStorage == null) {
            if (this.contentRootFolder == null) {
                this.contentRootFolder = System.getProperty("user.home") + File.separator + "content";
            }
            File contentRootFile = new File(this.contentRootFolder);
            if (this.createContentRootFolder && !contentRootFile.exists()) {
                contentRootFile.mkdirs();
            }
            if (contentRootFile != null && contentRootFile.exists()) {
                logger.info("Content file system root : {}", (Object)contentRootFile.getAbsolutePath());
            }
            this.contentStorage = new SimpleFileSystemContentStorage(contentRootFile);
        }
    }

    public void initDbSchema() {
        try {
            JdbcConnection connection = new JdbcConnection(this.dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName(LIQUIBASE_CHANGELOG_PREFIX + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)this.databaseSchema)) {
                database.setDefaultSchemaName(this.databaseSchema);
                database.setLiquibaseSchemaName(this.databaseSchema);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.databaseCatalog)) {
                database.setDefaultCatalogName(this.databaseCatalog);
                database.setLiquibaseCatalogName(this.databaseCatalog);
            }
            Liquibase liquibase = new Liquibase("org/flowable/content/db/liquibase/flowable-content-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            if ("drop-create".equals(this.databaseSchemaUpdate)) {
                logger.debug("Dropping and creating schema CONTENT");
                liquibase.dropAll();
                liquibase.update("content");
            } else if ("true".equals(this.databaseSchemaUpdate)) {
                logger.debug("Updating schema CONTENT");
                liquibase.update("content");
            } else if ("false".equals(this.databaseSchemaUpdate)) {
                logger.debug("Validating schema CONTENT");
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising content data schema", (Throwable)e);
        }
    }

    public void initSessionFactories() {
        if (this.sessionFactories == null) {
            this.sessionFactories = new HashMap();
            if (this.usingRelationalDatabase) {
                this.initDbSqlSessionFactory();
            }
        }
        if (this.customSessionFactories != null) {
            for (SessionFactory sessionFactory : this.customSessionFactories) {
                this.addSessionFactory(sessionFactory);
            }
        }
    }

    public void initDbSqlSessionFactory() {
        if (this.dbSqlSessionFactory == null) {
            this.dbSqlSessionFactory = this.createDbSqlSessionFactory();
        }
        this.dbSqlSessionFactory.setDatabaseType(this.databaseType);
        this.dbSqlSessionFactory.setSqlSessionFactory(this.sqlSessionFactory);
        this.dbSqlSessionFactory.setIdGenerator(this.idGenerator);
        this.dbSqlSessionFactory.setDatabaseTablePrefix(this.databaseTablePrefix);
        this.dbSqlSessionFactory.setTablePrefixIsSchema(this.tablePrefixIsSchema);
        this.dbSqlSessionFactory.setDatabaseCatalog(this.databaseCatalog);
        this.dbSqlSessionFactory.setDatabaseSchema(this.databaseSchema);
        this.addSessionFactory((SessionFactory)this.dbSqlSessionFactory);
    }

    public DbSqlSessionFactory createDbSqlSessionFactory() {
        return new DbSqlSessionFactory();
    }

    public void initCommandExecutors() {
        this.initDefaultCommandConfig();
        this.initSchemaCommandConfig();
        this.initCommandInvoker();
        this.initCommandInterceptors();
        this.initCommandExecutor();
    }

    public void initCommandInvoker() {
        if (this.commandInvoker == null) {
            this.commandInvoker = new CommandInvoker();
        }
    }

    public void initCommandInterceptors() {
        if (this.commandInterceptors == null) {
            this.commandInterceptors = new ArrayList<CommandInterceptor>();
            if (this.customPreCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPreCommandInterceptors);
            }
            this.commandInterceptors.addAll(this.getDefaultCommandInterceptors());
            if (this.customPostCommandInterceptors != null) {
                this.commandInterceptors.addAll(this.customPostCommandInterceptors);
            }
            this.commandInterceptors.add(this.commandInvoker);
        }
    }

    public Collection<? extends CommandInterceptor> getDefaultCommandInterceptors() {
        ArrayList<CommandInterceptor> interceptors = new ArrayList<CommandInterceptor>();
        interceptors.add(new LogInterceptor());
        interceptors.add(new CommandContextInterceptor(this.commandContextFactory, this));
        CommandInterceptor transactionInterceptor = this.createTransactionInterceptor();
        if (transactionInterceptor != null) {
            interceptors.add(transactionInterceptor);
        }
        return interceptors;
    }

    public void initCommandExecutor() {
        if (this.commandExecutor == null) {
            CommandInterceptor first = this.initInterceptorChain(this.commandInterceptors);
            this.commandExecutor = new CommandExecutorImpl(this.getDefaultCommandConfig(), first);
        }
    }

    public CommandInterceptor initInterceptorChain(List<CommandInterceptor> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new FlowableException("invalid command interceptor chain configuration: " + chain);
        }
        for (int i = 0; i < chain.size() - 1; ++i) {
            chain.get(i).setNext(chain.get(i + 1));
        }
        return chain.get(0);
    }

    public CommandInterceptor createTransactionInterceptor() {
        if (this.transactionContextFactory != null) {
            return new TransactionContextInterceptor(this.transactionContextFactory);
        }
        return null;
    }

    public void initCommandContextFactory() {
        if (this.commandContextFactory == null) {
            this.commandContextFactory = new CommandContextFactory();
        }
        this.commandContextFactory.setDmnEngineConfiguration(this);
    }

    public void initTransactionContextFactory() {
        if (this.transactionContextFactory == null) {
            this.transactionContextFactory = new StandaloneMybatisTransactionContextFactory();
        }
    }

    public InputStream getMyBatisXmlConfigurationStream() {
        return this.getResourceAsStream(DEFAULT_MYBATIS_MAPPING_FILE);
    }

    public String getEngineName() {
        return this.contentEngineName;
    }

    public ContentEngineConfiguration setEngineName(String contentEngineName) {
        this.contentEngineName = contentEngineName;
        return this;
    }

    public ContentEngineConfiguration setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        return this;
    }

    public ContentEngineConfiguration setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public ContentEngineConfiguration setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
        return this;
    }

    public ContentEngineConfiguration setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public ContentEngineConfiguration setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
        return this;
    }

    public ContentEngineConfiguration setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
        return this;
    }

    public ContentEngineConfiguration setJdbcMaxActiveConnections(int jdbcMaxActiveConnections) {
        this.jdbcMaxActiveConnections = jdbcMaxActiveConnections;
        return this;
    }

    public ContentEngineConfiguration setJdbcMaxIdleConnections(int jdbcMaxIdleConnections) {
        this.jdbcMaxIdleConnections = jdbcMaxIdleConnections;
        return this;
    }

    public ContentEngineConfiguration setJdbcMaxCheckoutTime(int jdbcMaxCheckoutTime) {
        this.jdbcMaxCheckoutTime = jdbcMaxCheckoutTime;
        return this;
    }

    public ContentEngineConfiguration setJdbcMaxWaitTime(int jdbcMaxWaitTime) {
        this.jdbcMaxWaitTime = jdbcMaxWaitTime;
        return this;
    }

    public ContentEngineConfiguration setJdbcPingEnabled(boolean jdbcPingEnabled) {
        this.jdbcPingEnabled = jdbcPingEnabled;
        return this;
    }

    public ContentEngineConfiguration setJdbcPingConnectionNotUsedFor(int jdbcPingConnectionNotUsedFor) {
        this.jdbcPingConnectionNotUsedFor = jdbcPingConnectionNotUsedFor;
        return this;
    }

    public ContentEngineConfiguration setJdbcDefaultTransactionIsolationLevel(int jdbcDefaultTransactionIsolationLevel) {
        this.jdbcDefaultTransactionIsolationLevel = jdbcDefaultTransactionIsolationLevel;
        return this;
    }

    public ContentEngineConfiguration setJdbcPingQuery(String jdbcPingQuery) {
        this.jdbcPingQuery = jdbcPingQuery;
        return this;
    }

    public ContentEngineConfiguration setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
        return this;
    }

    public ContentEngineConfiguration setXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
        return this;
    }

    public ContentEngineConfiguration setDefaultCommandConfig(CommandConfig defaultCommandConfig) {
        this.defaultCommandConfig = defaultCommandConfig;
        return this;
    }

    public CommandInterceptor getCommandInvoker() {
        return this.commandInvoker;
    }

    public ContentEngineConfiguration setCommandInvoker(CommandInterceptor commandInvoker) {
        this.commandInvoker = commandInvoker;
        return this;
    }

    public List<CommandInterceptor> getCustomPreCommandInterceptors() {
        return this.customPreCommandInterceptors;
    }

    public ContentEngineConfiguration setCustomPreCommandInterceptors(List<CommandInterceptor> customPreCommandInterceptors) {
        this.customPreCommandInterceptors = customPreCommandInterceptors;
        return this;
    }

    public List<CommandInterceptor> getCustomPostCommandInterceptors() {
        return this.customPostCommandInterceptors;
    }

    public ContentEngineConfiguration setCustomPostCommandInterceptors(List<CommandInterceptor> customPostCommandInterceptors) {
        this.customPostCommandInterceptors = customPostCommandInterceptors;
        return this;
    }

    public List<CommandInterceptor> getCommandInterceptors() {
        return this.commandInterceptors;
    }

    public ContentEngineConfiguration setCommandInterceptors(List<CommandInterceptor> commandInterceptors) {
        this.commandInterceptors = commandInterceptors;
        return this;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public ContentEngineConfiguration setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        return this;
    }

    public ContentManagementService getContentManagementService() {
        return this.contentManagementService;
    }

    public ContentEngineConfiguration setContentManagementService(ContentManagementService contentManagementService) {
        this.contentManagementService = contentManagementService;
        return this;
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public ContentEngineConfiguration setContentService(ContentService contentService) {
        this.contentService = contentService;
        return this;
    }

    public ContentEngineConfiguration getContentEngineConfiguration() {
        return this;
    }

    public ContentItemDataManager getContentItemDataManager() {
        return this.contentItemDataManager;
    }

    public ContentEngineConfiguration setContentItemDataManager(ContentItemDataManager contentItemDataManager) {
        this.contentItemDataManager = contentItemDataManager;
        return this;
    }

    public ContentItemEntityManager getContentItemEntityManager() {
        return this.contentItemEntityManager;
    }

    public ContentEngineConfiguration setContentItemEntityManager(ContentItemEntityManager contentItemEntityManager) {
        this.contentItemEntityManager = contentItemEntityManager;
        return this;
    }

    public TableDataManager getTableDataManager() {
        return this.tableDataManager;
    }

    public ContentEngineConfiguration setTableDataManager(TableDataManager tableDataManager) {
        this.tableDataManager = tableDataManager;
        return this;
    }

    public ContentStorage getContentStorage() {
        return this.contentStorage;
    }

    public ContentEngineConfiguration setContentStorage(ContentStorage contentStorage) {
        this.contentStorage = contentStorage;
        return this;
    }

    public String getContentRootFolder() {
        return this.contentRootFolder;
    }

    public ContentEngineConfiguration setContentRootFolder(String contentRootFolder) {
        this.contentRootFolder = contentRootFolder;
        return this;
    }

    public boolean isCreateContentRootFolder() {
        return this.createContentRootFolder;
    }

    public ContentEngineConfiguration setCreateContentRootFolder(boolean createContentRootFolder) {
        this.createContentRootFolder = createContentRootFolder;
        return this;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public ContentEngineConfiguration setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
        return this;
    }

    public ContentEngineConfiguration setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public ContentEngineConfiguration setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
        return this;
    }

    public ContentEngineConfiguration setCustomMybatisMappers(Set<Class<?>> customMybatisMappers) {
        this.customMybatisMappers = customMybatisMappers;
        return this;
    }

    public ContentEngineConfiguration setCustomMybatisXMLMappers(Set<String> customMybatisXMLMappers) {
        this.customMybatisXMLMappers = customMybatisXMLMappers;
        return this;
    }

    public ContentEngineConfiguration setCustomSessionFactories(List<SessionFactory> customSessionFactories) {
        this.customSessionFactories = customSessionFactories;
        return this;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public ContentEngineConfiguration setDbSqlSessionFactory(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        return this;
    }

    public ContentEngineConfiguration setUsingRelationalDatabase(boolean usingRelationalDatabase) {
        this.usingRelationalDatabase = usingRelationalDatabase;
        return this;
    }

    public ContentEngineConfiguration setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
        return this;
    }

    public ContentEngineConfiguration setDatabaseCatalog(String databaseCatalog) {
        this.databaseCatalog = databaseCatalog;
        return this;
    }

    public ContentEngineConfiguration setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
        return this;
    }

    public ContentEngineConfiguration setTablePrefixIsSchema(boolean tablePrefixIsSchema) {
        this.tablePrefixIsSchema = tablePrefixIsSchema;
        return this;
    }

    public ContentEngineConfiguration setSessionFactories(Map<Class<?>, SessionFactory> sessionFactories) {
        this.sessionFactories = sessionFactories;
        return this;
    }

    public TransactionContextFactory<TransactionListener, CommandContext> getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public ContentEngineConfiguration setTransactionContextFactory(TransactionContextFactory<TransactionListener, CommandContext> transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
        return this;
    }

    public ContentEngineConfiguration setDatabaseSchemaUpdate(String databaseSchemaUpdate) {
        this.databaseSchemaUpdate = databaseSchemaUpdate;
        return this;
    }

    public ContentEngineConfiguration setClock(Clock clock) {
        this.clock = clock;
        return this;
    }
}

