/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl;

import java.io.InputStream;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentItemQuery;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.impl.ContentItemQueryImpl;
import org.flowable.content.engine.impl.ServiceImpl;
import org.flowable.content.engine.impl.cmd.CreateContentItemCmd;
import org.flowable.content.engine.impl.cmd.DeleteContentItemCmd;
import org.flowable.content.engine.impl.cmd.DeleteContentItemsCmd;
import org.flowable.content.engine.impl.cmd.GetContentItemStreamCmd;
import org.flowable.content.engine.impl.cmd.SaveContentItemCmd;

public class ContentServiceImpl
extends ServiceImpl
implements ContentService {
    public ContentItem newContentItem() {
        return this.commandExecutor.execute(new CreateContentItemCmd());
    }

    public void saveContentItem(ContentItem contentItem) {
        this.commandExecutor.execute(new SaveContentItemCmd(contentItem));
    }

    public void saveContentItem(ContentItem contentItem, InputStream inputStream) {
        this.commandExecutor.execute(new SaveContentItemCmd(contentItem, inputStream));
    }

    public InputStream getContentItemData(String contentItemId) {
        return this.commandExecutor.execute(new GetContentItemStreamCmd(contentItemId));
    }

    public void deleteContentItem(String contentItemId) {
        this.commandExecutor.execute(new DeleteContentItemCmd(contentItemId));
    }

    public void deleteContentItemsByProcessInstanceId(String processInstanceId) {
        this.commandExecutor.execute(new DeleteContentItemsCmd(processInstanceId, null));
    }

    public void deleteContentItemsByTaskId(String taskId) {
        this.commandExecutor.execute(new DeleteContentItemsCmd(null, taskId));
    }

    public ContentItemQuery createContentItemQuery() {
        return new ContentItemQueryImpl(this.commandExecutor);
    }
}

