/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentObject;
import org.flowable.content.api.ContentStorage;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.impl.interceptor.Command;
import org.flowable.content.engine.impl.interceptor.CommandContext;
import org.flowable.content.engine.impl.persistence.entity.ContentItemEntity;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;

public class SaveContentItemCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ContentItem contentItem;
    protected InputStream inputStream;

    public SaveContentItemCmd(ContentItem contentItem) {
        this.contentItem = contentItem;
    }

    public SaveContentItemCmd(ContentItem contentItem, InputStream inputStream) {
        this.contentItem = contentItem;
        this.inputStream = inputStream;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.contentItem == null) {
            throw new FlowableIllegalArgumentException("contentItem is null");
        }
        if (!(this.contentItem instanceof ContentItemEntity)) {
            throw new FlowableIllegalArgumentException("contentItem is not of type ContentItemEntity");
        }
        ContentItemEntity contentItemEntity = (ContentItemEntity)this.contentItem;
        ContentEngineConfiguration contentEngineConfiguration = commandContext.getContentEngineConfiguration();
        if (this.inputStream != null) {
            HashMap<String, String> metaData = new HashMap<String, String>();
            if (this.contentItem.getTaskId() != null) {
                metaData.put("taskId", this.contentItem.getTaskId());
            } else if (this.contentItem.getProcessInstanceId() != null) {
                metaData.put("processInstanceId", this.contentItem.getProcessInstanceId());
            }
            ContentStorage contentStorage = contentEngineConfiguration.getContentStorage();
            ContentObject createContentObject = contentStorage.createContentObject(this.inputStream, metaData);
            contentItemEntity.setContentStoreId(createContentObject.getId());
            contentItemEntity.setContentStoreName(contentStorage.getContentStoreName());
            contentItemEntity.setContentAvailable(true);
            contentItemEntity.setContentSize(createContentObject.getContentLength());
        }
        if (contentItemEntity.getLastModified() == null) {
            contentItemEntity.setLastModified(contentEngineConfiguration.getClock().getCurrentTime());
        }
        if (this.contentItem.getId() == null) {
            if (contentItemEntity.getCreated() == null) {
                contentItemEntity.setCreated(contentEngineConfiguration.getClock().getCurrentTime());
            }
            commandContext.getContentItemEntityManager().insert(contentItemEntity);
        } else {
            commandContext.getContentItemEntityManager().update(contentItemEntity);
        }
        return null;
    }
}

