/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.db;

import java.sql.Connection;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.flowable.content.engine.impl.db.DbSqlSessionFactory;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.db.AbstractDbSqlSessionFactory;
import org.flowable.engine.common.impl.db.AbstractNonCachingDbSqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlSession
extends AbstractNonCachingDbSqlSession {
    private static final Logger log = LoggerFactory.getLogger(DbSqlSession.class);

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        super((AbstractDbSqlSessionFactory)dbSqlSessionFactory);
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        super((AbstractDbSqlSessionFactory)dbSqlSessionFactory, connection, catalog, schema);
    }

    public void dbSchemaCheckVersion() {
        log.debug("flowable content db schema check successful");
    }

    public void dbSchemaCreate() {
        Liquibase liquibase = this.createLiquibaseInstance();
        try {
            liquibase.update("form");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating form engine tables", (Throwable)e);
        }
    }

    public void dbSchemaDrop() {
        Liquibase liquibase = this.createLiquibaseInstance();
        try {
            liquibase.dropAll();
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping form engine tables", (Throwable)e);
        }
    }

    protected Liquibase createLiquibaseInstance() {
        try {
            JdbcConnection connection = new JdbcConnection(this.sqlSession.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_CO_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_CO_" + database.getDatabaseChangeLogLockTableName());
            Liquibase liquibase = new Liquibase("org/flowable/form/db/liquibase/flowable-form-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            return liquibase;
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping form engine tables", (Throwable)e);
        }
    }
}

