/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.interceptor;

import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.impl.context.Context;
import org.flowable.content.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.content.engine.impl.interceptor.Command;
import org.flowable.content.engine.impl.interceptor.CommandContext;
import org.flowable.content.engine.impl.interceptor.CommandContextFactory;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContextInterceptor
extends AbstractCommandInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CommandContextInterceptor.class);
    protected CommandContextFactory commandContextFactory;
    protected ContentEngineConfiguration contentEngineConfiguration;

    public CommandContextInterceptor() {
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory, ContentEngineConfiguration contentEngineConfiguration) {
        this.commandContextFactory = commandContextFactory;
        this.contentEngineConfiguration = contentEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext context = Context.getCommandContext();
        boolean contextReused = false;
        if (!config.isContextReusePossible() || context == null || context.getException() != null) {
            context = this.commandContextFactory.createCommandContext(command);
        } else {
            log.debug("Valid context found. Reusing it for the current command '{}'", (Object)command.getClass().getCanonicalName());
            contextReused = true;
        }
        try {
            Context.setCommandContext(context);
            Context.setContentEngineConfiguration(this.contentEngineConfiguration);
            T t = this.next.execute(config, command);
            return t;
        }
        catch (Exception e) {
            context.exception(e);
        }
        finally {
            try {
                if (!contextReused) {
                    context.close();
                }
            }
            finally {
                Context.removeCommandContext();
                Context.removeContentEngineConfiguration();
            }
        }
        return null;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public ContentEngineConfiguration getContentEngineConfiguration() {
        return this.contentEngineConfiguration;
    }

    public void setContentEngineConfiguration(ContentEngineConfiguration contentEngineConfiguration) {
        this.contentEngineConfiguration = contentEngineConfiguration;
    }
}

