/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.db;

import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.flowable.content.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.db.DbSchemaManager;
import org.flowable.engine.common.impl.db.DbSqlSession;

public class ContentDbSchemaManager
implements DbSchemaManager {
    public void dbSchemaCreate() {
        Liquibase liquibase = ContentDbSchemaManager.createLiquibaseInstance();
        try {
            liquibase.update("form");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating form engine tables", (Throwable)e);
        }
    }

    public void dbSchemaDrop() {
        Liquibase liquibase = ContentDbSchemaManager.createLiquibaseInstance();
        try {
            liquibase.dropAll();
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping form engine tables", (Throwable)e);
        }
    }

    public String dbSchemaUpdate() {
        this.dbSchemaCreate();
        return null;
    }

    protected static Liquibase createLiquibaseInstance() {
        try {
            DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
            JdbcConnection connection = new JdbcConnection(dbSqlSession.getSqlSession().getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("ACT_CO_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("ACT_CO_" + database.getDatabaseChangeLogLockTableName());
            Liquibase liquibase = new Liquibase("org/flowable/form/db/liquibase/flowable-form-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            return liquibase;
        }
        catch (Exception e) {
            throw new FlowableException("Error creating liquibase instance", (Throwable)e);
        }
    }
}

