/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl;

import java.io.InputStream;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentItemQuery;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.impl.ContentItemQueryImpl;
import org.flowable.content.engine.impl.ServiceImpl;
import org.flowable.content.engine.impl.cmd.CreateContentItemCmd;
import org.flowable.content.engine.impl.cmd.DeleteContentItemCmd;
import org.flowable.content.engine.impl.cmd.DeleteContentItemsCmd;
import org.flowable.content.engine.impl.cmd.GetContentItemStreamCmd;
import org.flowable.content.engine.impl.cmd.SaveContentItemCmd;
import org.flowable.engine.common.impl.interceptor.Command;

public class ContentServiceImpl
extends ServiceImpl
implements ContentService {
    public ContentItem newContentItem() {
        return (ContentItem)this.commandExecutor.execute((Command)new CreateContentItemCmd());
    }

    public void saveContentItem(ContentItem contentItem) {
        this.commandExecutor.execute((Command)new SaveContentItemCmd(contentItem));
    }

    public void saveContentItem(ContentItem contentItem, InputStream inputStream) {
        this.commandExecutor.execute((Command)new SaveContentItemCmd(contentItem, inputStream));
    }

    public InputStream getContentItemData(String contentItemId) {
        return (InputStream)this.commandExecutor.execute((Command)new GetContentItemStreamCmd(contentItemId));
    }

    public void deleteContentItem(String contentItemId) {
        this.commandExecutor.execute((Command)new DeleteContentItemCmd(contentItemId));
    }

    public void deleteContentItemsByProcessInstanceId(String processInstanceId) {
        this.commandExecutor.execute((Command)new DeleteContentItemsCmd(processInstanceId, null));
    }

    public void deleteContentItemsByTaskId(String taskId) {
        this.commandExecutor.execute((Command)new DeleteContentItemsCmd(null, taskId));
    }

    public ContentItemQuery createContentItemQuery() {
        return new ContentItemQueryImpl(this.commandExecutor);
    }
}

