/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentObject;
import org.flowable.content.api.ContentStorage;
import org.flowable.content.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;

public class GetContentItemStreamCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String contentItemId;

    public GetContentItemStreamCmd(String contentItemId) {
        this.contentItemId = contentItemId;
    }

    public InputStream execute(CommandContext commandContext) {
        if (this.contentItemId == null) {
            throw new FlowableIllegalArgumentException("contentItemId is null");
        }
        ContentItem contentItem = (ContentItem)CommandContextUtil.getContentItemEntityManager().findById(this.contentItemId);
        if (contentItem == null) {
            throw new FlowableObjectNotFoundException("content item could not be found with id " + this.contentItemId);
        }
        ContentStorage contentStorage = CommandContextUtil.getContentEngineConfiguration().getContentStorage();
        ContentObject contentObject = contentStorage.getContentObject(contentItem.getContentStoreId());
        return contentObject.getContent();
    }
}

