/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.rest.service.api.management;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngines;
import org.flowable.content.rest.ContentRestApiInterceptor;
import org.flowable.content.rest.service.api.management.ContentEngineInfoResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Engine"}, description="Manage Content Engine", authorizations={@Authorization(value="basicAuth")})
public class ContentEngineResource {
    @Autowired(required=false)
    protected ContentRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get Content engine info", tags={"Engine"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the engine info is returned.")})
    @GetMapping(value={"/content-management/engine"}, produces={"application/json"})
    public ContentEngineInfoResponse getEngineInfo() {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessContentManagementInfo();
        }
        ContentEngineInfoResponse response = new ContentEngineInfoResponse();
        try {
            ContentEngine contentEngine = ContentEngines.getDefaultContentEngine();
            EngineInfo contentEngineInfo = ContentEngines.getContentEngineInfo((String)contentEngine.getName());
            if (contentEngineInfo != null) {
                response.setName(contentEngineInfo.getName());
                response.setResourceUrl(contentEngineInfo.getResourceUrl());
                response.setException(contentEngineInfo.getException());
            } else {
                response.setName(contentEngine.getName());
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error retrieving content engine info", (Throwable)e);
        }
        response.setVersion("6.5.0.6");
        return response;
    }
}

