/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.rest.service.api.content;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.content.rest.service.api.content.ContentItemBaseResource;
import org.flowable.content.rest.service.api.content.ContentItemQueryRequest;
import org.flowable.content.rest.service.api.content.ContentItemResponse;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Content item"}, description="Query content items", authorizations={@Authorization(value="basicAuth")})
public class ContentItemQueryResource
extends ContentItemBaseResource {
    @ApiOperation(value="Query for content items", tags={"Content item", "Query"}, notes="All supported JSON parameter fields allowed are exactly the same as the parameters found for getting a collection of content items, but passed in as JSON-body arguments rather than URL-parameters to allow for more advanced querying and preventing errors with request-uri\u2019s that are too long.")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the content items are returned."), @ApiResponse(code=400, message="Indicates a parameter was passed in the wrong format. The status-message contains additional information.")})
    @PostMapping(value={"/query/content-items"}, produces={"application/json"})
    public DataResponse<ContentItemResponse> getQueryResult(@RequestBody ContentItemQueryRequest request, @ApiParam(hidden=true) @RequestParam Map<String, String> requestParams, HttpServletRequest httpRequest) {
        return this.getContentItemsFromQueryRequest(request, requestParams);
    }
}

