/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.deployer;

import java.util.Map;
import org.flowable.dmn.api.DmnDeploymentBuilder;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.engine.impl.deployer.DmnResourceUtil;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.engine.common.api.repository.EngineDeployment;
import org.flowable.engine.common.api.repository.EngineResource;
import org.flowable.engine.common.impl.EngineDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnDeployer
implements EngineDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnDeployer.class);

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        if (!deployment.isNew()) {
            return;
        }
        LOGGER.debug("DmnDeployer: processing deployment {}", (Object)deployment.getName());
        DmnDeploymentBuilder dmnDeploymentBuilder = null;
        Map resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!DmnResourceUtil.isDmnResource((String)resourceName)) continue;
            LOGGER.info("DmnDeployer: processing resource {}", (Object)resourceName);
            if (dmnDeploymentBuilder == null) {
                DmnRepositoryService dmnRepositoryService = CommandContextUtil.getDmnRepositoryService();
                dmnDeploymentBuilder = dmnRepositoryService.createDeployment();
            }
            dmnDeploymentBuilder.addDmnBytes(resourceName, ((EngineResource)resources.get(resourceName)).getBytes());
        }
        if (dmnDeploymentBuilder != null) {
            dmnDeploymentBuilder.parentDeploymentId(deployment.getId());
            if (deployment.getTenantId() != null && deployment.getTenantId().length() > 0) {
                dmnDeploymentBuilder.tenantId(deployment.getTenantId());
            }
            dmnDeploymentBuilder.deploy();
        }
    }
}

