/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.dmn.engine.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.dmn.engine.impl.interceptor.Command;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;

public class GetDeploymentDmnResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String decisionTableId;

    public GetDeploymentDmnResourceCmd(String decisionTableId) {
        if (decisionTableId == null || decisionTableId.length() < 1) {
            throw new FlowableIllegalArgumentException("The decision table id is mandatory, but '" + decisionTableId + "' has been provided.");
        }
        this.decisionTableId = decisionTableId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        DecisionTableEntity decisionTable = commandContext.getDmnEngineConfiguration().getDeploymentManager().findDeployedDecisionById(this.decisionTableId);
        String deploymentId = decisionTable.getDeploymentId();
        String resourceName = decisionTable.getResourceName();
        InputStream processModelStream = new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
        return processModelStream;
    }
}

