/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.flowable.dmn.api.DmnManagementService;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.api.DmnRuleService;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.db.DbSqlSession;
import org.flowable.dmn.engine.impl.interceptor.Command;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.interceptor.CommandExecutor;
import org.flowable.dmn.engine.impl.test.AbstractDmnTestCase;
import org.flowable.dmn.engine.test.DmnTestHelper;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.junit.Assert;

public abstract class AbstractFlowableDmnTestCase
extends AbstractDmnTestCase {
    private static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = new ArrayList<String>();
    protected DmnEngine dmnEngine;
    protected String deploymentIdFromDeploymentAnnotation;
    protected List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected Throwable exception;
    protected DmnEngineConfiguration dmnEngineConfiguration;
    protected DmnManagementService managementService;
    protected DmnRepositoryService repositoryService;
    protected DmnRuleService ruleService;

    protected abstract void initializeDmnEngine();

    protected void closeDownDmnEngine() {
    }

    protected void nullifyServices() {
        this.dmnEngineConfiguration = null;
        this.managementService = null;
        this.repositoryService = null;
        this.ruleService = null;
    }

    public void runBare() throws Throwable {
        this.initializeDmnEngine();
        if (this.repositoryService == null) {
            this.initializeServices();
        }
        try {
            this.deploymentIdFromDeploymentAnnotation = DmnTestHelper.annotationDeploymentSetUp(this.dmnEngine, ((Object)((Object)this)).getClass(), this.getName());
            super.runBare();
        }
        catch (AssertionFailedError e) {
            log.error("\n");
            log.error("ASSERTION FAILED: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        catch (Throwable e) {
            log.error("\n");
            log.error("EXCEPTION: {}", (Object)e, (Object)e);
            this.exception = e;
            throw e;
        }
        finally {
            if (this.deploymentIdFromDeploymentAnnotation != null) {
                DmnTestHelper.annotationDeploymentTearDown(this.dmnEngine, this.deploymentIdFromDeploymentAnnotation, ((Object)((Object)this)).getClass(), this.getName());
                this.deploymentIdFromDeploymentAnnotation = null;
            }
            for (String autoDeletedDeploymentId : this.deploymentIdsForAutoCleanup) {
                this.repositoryService.deleteDeployment(autoDeletedDeploymentId);
            }
            this.deploymentIdsForAutoCleanup.clear();
            this.assertAndEnsureCleanDb();
            this.dmnEngineConfiguration.getClock().reset();
            this.closeDownDmnEngine();
        }
    }

    protected void assertAndEnsureCleanDb() throws Throwable {
        log.debug("verifying that db is clean after test");
        Map tableCounts = this.managementService.getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(this.dmnEngineConfiguration.getDatabaseTablePrefix(), "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = (Long)tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("  ").append(tableName).append(": ").append(count).append(" record(s) ");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            log.error("\n");
            log.error(outputMessage.toString());
            log.info("dropping and recreating db");
            CommandExecutor commandExecutor = this.dmnEngine.getDmnEngineConfiguration().getCommandExecutor();
            CommandConfig config = new CommandConfig().transactionNotSupported();
            commandExecutor.execute(config, new Command<Object>(){

                @Override
                public Object execute(CommandContext commandContext) {
                    DbSqlSession session = commandContext.getDbSqlSession();
                    session.dbSchemaDrop();
                    session.dbSchemaCreate();
                    return null;
                }
            });
            if (this.exception != null) {
                throw this.exception;
            }
            Assert.fail((String)outputMessage.toString());
        } else {
            log.info("database was clean");
        }
    }

    protected void initializeServices() {
        this.dmnEngineConfiguration = this.dmnEngine.getDmnEngineConfiguration();
        this.managementService = this.dmnEngine.getDmnManagementService();
        this.repositoryService = this.dmnEngine.getDmnRepositoryService();
        this.ruleService = this.dmnEngine.getDmnRuleService();
    }

    static {
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_DMN_DATABASECHANGELOG");
        TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.add("ACT_DMN_DATABASECHANGELOGLOCK");
    }
}

