/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import org.flowable.dmn.engine.impl.interceptor.Command;
import org.flowable.dmn.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.persistence.deploy.DecisionTableCacheEntry;
import org.flowable.dmn.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionTableEntity;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;

public class SetDecisionTableCategoryCmd
implements Command<Void> {
    protected String decisionTableId;
    protected String category;

    public SetDecisionTableCategoryCmd(String decisionTableId, String category) {
        this.decisionTableId = decisionTableId;
        this.category = category;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.decisionTableId == null) {
            throw new FlowableIllegalArgumentException("Decision table id is null");
        }
        DecisionTableEntity decisionTable = (DecisionTableEntity)commandContext.getDecisionTableEntityManager().findById(this.decisionTableId);
        if (decisionTable == null) {
            throw new FlowableObjectNotFoundException("No decision table found for id = '" + this.decisionTableId + "'");
        }
        decisionTable.setCategory(this.category);
        DeploymentCache<DecisionTableCacheEntry> decisionTableCache = commandContext.getDmnEngineConfiguration().getDecisionCache();
        if (decisionTableCache != null) {
            decisionTableCache.remove(this.decisionTableId);
        }
        commandContext.getDecisionTableEntityManager().update(decisionTable);
        return null;
    }

    public String getDecisionTableId() {
        return this.decisionTableId;
    }

    public void setDecisionTableId(String decisionTableId) {
        this.decisionTableId = decisionTableId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

