/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el;

import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.dmn.engine.FlowableDmnExpressionException;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.el.ELInputEntryExpressionPreParser;
import org.flowable.dmn.engine.impl.el.ELOutputEntryExpressionPreParser;
import org.flowable.dmn.engine.impl.el.RuleExpressionCondition;
import org.flowable.dmn.engine.impl.el.RuleExpressionOutput;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.LiteralExpression;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.model.UnaryTests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELExpressionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ELExpressionExecutor.class);

    public static Boolean executeInputExpression(InputClause inputClause, UnaryTests inputEntry, ExpressionManager expressionManager, ELExecutionContext executionContext) {
        if (inputClause == null) {
            throw new IllegalArgumentException("input clause is required");
        }
        if (inputClause.getInputExpression() == null) {
            throw new IllegalArgumentException("input expression is required");
        }
        if (inputEntry == null) {
            throw new IllegalArgumentException("input entry is required");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("execution context is required");
        }
        String inputExpression = inputClause.getInputExpression().getText();
        executionContext.checkExecutionContext(inputExpression);
        String parsedExpression = ELInputEntryExpressionPreParser.parse(inputEntry.getText(), inputExpression, inputClause.getInputExpression().getTypeRef());
        Expression expression = expressionManager.createExpression(parsedExpression);
        RuleExpressionCondition condition = new RuleExpressionCondition(expression);
        try {
            return condition.evaluate(executionContext.getStackVariables());
        }
        catch (Exception ex) {
            LOGGER.warn("Error while executing input entry: {}", (Object)parsedExpression, (Object)ex);
            throw new FlowableDmnExpressionException("error while executing input entry", parsedExpression, ex);
        }
    }

    public static Object executeOutputExpression(OutputClause outputClause, LiteralExpression outputEntry, ExpressionManager expressionManager, ELExecutionContext executionContext) {
        if (outputClause == null) {
            throw new IllegalArgumentException("output clause is required");
        }
        if (outputEntry == null) {
            throw new IllegalArgumentException("output entry is required");
        }
        if (executionContext == null) {
            throw new IllegalArgumentException("execution context is required");
        }
        String parsedExpression = ELOutputEntryExpressionPreParser.parse(outputEntry.getText());
        Expression expression = expressionManager.createExpression(parsedExpression);
        RuleExpressionOutput outputExpression = new RuleExpressionOutput(expression);
        try {
            return outputExpression.getValue(executionContext.getStackVariables());
        }
        catch (Exception ex) {
            LOGGER.warn("Error while executing output entry: {}", (Object)outputEntry.getText(), (Object)ex);
            throw new FlowableDmnExpressionException("error while executing output entry", outputEntry.getText(), ex);
        }
    }
}

