/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.db;

import java.sql.Connection;
import java.sql.SQLException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnDbSchemaManager
implements SchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnDbSchemaManager.class);
    public static String LIQUIBASE_CHANGELOG = "org/flowable/dmn/db/liquibase/flowable-dmn-db-changelog.xml";

    public void initSchema() {
        this.initSchema(CommandContextUtil.getDmnEngineConfiguration());
    }

    public void initSchema(DmnEngineConfiguration dmnEngineConfiguration) {
        this.initSchema(dmnEngineConfiguration, dmnEngineConfiguration.getDatabaseSchemaUpdate());
    }

    public void initSchema(DmnEngineConfiguration dmnEngineConfiguration, String databaseSchemaUpdate) {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(dmnEngineConfiguration);
            if ("drop-create".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Dropping and creating schema DMN");
                liquibase.dropAll();
                liquibase.update("dmn");
            } else if ("true".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Updating schema DMN");
                liquibase.update("dmn");
            } else if ("false".equals(databaseSchemaUpdate)) {
                LOGGER.debug("Validating schema DMN");
                liquibase.validate();
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error initialising dmn data model", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    public Liquibase createLiquibaseInstance(DmnEngineConfiguration dmnEngineConfiguration) throws SQLException, DatabaseException, LiquibaseException {
        String databaseCatalog;
        Connection jdbcConnection = null;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        jdbcConnection = commandContext == null ? dmnEngineConfiguration.getDataSource().getConnection() : CommandContextUtil.getDbSqlSession(commandContext).getSqlSession().getConnection();
        if (!jdbcConnection.getAutoCommit()) {
            jdbcConnection.commit();
        }
        JdbcConnection connection = new JdbcConnection(jdbcConnection);
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
        database.setDatabaseChangeLogTableName("ACT_DMN_" + database.getDatabaseChangeLogTableName());
        database.setDatabaseChangeLogLockTableName("ACT_DMN_" + database.getDatabaseChangeLogLockTableName());
        String databaseSchema = dmnEngineConfiguration.getDatabaseSchema();
        if (StringUtils.isNotEmpty((CharSequence)databaseSchema)) {
            database.setDefaultSchemaName(databaseSchema);
            database.setLiquibaseSchemaName(databaseSchema);
        }
        if (StringUtils.isNotEmpty((CharSequence)(databaseCatalog = dmnEngineConfiguration.getDatabaseCatalog()))) {
            database.setDefaultCatalogName(databaseCatalog);
            database.setLiquibaseCatalogName(databaseCatalog);
        }
        Liquibase liquibase = new Liquibase(LIQUIBASE_CHANGELOG, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        return liquibase;
    }

    public void schemaCreate() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(CommandContextUtil.getDmnEngineConfiguration());
            liquibase.update("dmn");
        }
        catch (Exception e) {
            throw new FlowableException("Error creating DMN engine tables", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    public void schemaDrop() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(CommandContextUtil.getDmnEngineConfiguration());
            liquibase.dropAll();
        }
        catch (Exception e) {
            throw new FlowableException("Error dropping DMN engine tables", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    public String schemaUpdate() {
        this.schemaCreate();
        return null;
    }

    public void schemaCheckVersion() {
        Liquibase liquibase = null;
        try {
            liquibase = this.createLiquibaseInstance(CommandContextUtil.getDmnEngineConfiguration());
            liquibase.validate();
        }
        catch (Exception e) {
            throw new FlowableException("Error validating app engine schema", (Throwable)e);
        }
        finally {
            this.closeDatabase(liquibase);
        }
    }

    private void closeDatabase(Liquibase liquibase) {
        Database database;
        if (liquibase != null && (database = liquibase.getDatabase()) != null && CommandContextUtil.getCommandContext() == null) {
            try {
                database.close();
            }
            catch (DatabaseException e) {
                LOGGER.warn("Error closing database", (Throwable)e);
            }
        }
    }
}

