/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.ExecuteDecisionContext;
import org.flowable.dmn.engine.impl.audit.DecisionExecutionAuditUtil;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.el.ExecutionVariableFactory;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.OutputClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELExecutionContextBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ELExecutionContextBuilder.class);

    public static ELExecutionContext build(DecisionService decisionService, ExecuteDecisionContext executeDecisionInfo) {
        ELExecutionContext executionContext = new ELExecutionContext();
        executionContext.setInstanceId(executeDecisionInfo.getInstanceId());
        executionContext.setScopeType(executeDecisionInfo.getScopeType());
        executionContext.setTenantId(executeDecisionInfo.getTenantId());
        executionContext.setAuditContainer((DecisionExecutionAuditContainer)DecisionExecutionAuditUtil.initializeDecisionServiceExecutionAudit(decisionService, executeDecisionInfo));
        return executionContext;
    }

    public static ELExecutionContext build(Decision decision, ExecuteDecisionContext executeDecisionInfo) {
        ELExecutionContext executionContext = new ELExecutionContext();
        executionContext.setInstanceId(executeDecisionInfo.getInstanceId());
        executionContext.setScopeType(executeDecisionInfo.getScopeType());
        executionContext.setTenantId(executeDecisionInfo.getTenantId());
        executionContext.setForceDMN11(decision.isForceDMN11());
        executionContext.setAuditContainer(DecisionExecutionAuditUtil.initializeDecisionExecutionAudit(decision, executeDecisionInfo));
        DecisionTable decisionTable = (DecisionTable)decision.getExpression();
        if (decisionTable.getOutputs() != null) {
            for (OutputClause outputClause : decisionTable.getOutputs()) {
                if (outputClause.getOutputValues() == null || outputClause.getOutputValues().getTextValues() == null) continue;
                executionContext.addOutputValues(outputClause.getName(), ExecutionVariableFactory.getExecutionVariables(outputClause.getTypeRef(), outputClause.getOutputValues().getTextValues()));
            }
        }
        if (decisionTable.getAggregation() != null) {
            executionContext.setAggregator(decisionTable.getAggregation());
        }
        Map inputVariables = executeDecisionInfo.getVariables();
        ELExecutionContextBuilder.preProcessInputVariables(decisionTable, inputVariables);
        executionContext.setStackVariables(inputVariables);
        LOGGER.debug("Execution Context created");
        return executionContext;
    }

    protected static void preProcessInputVariables(DecisionTable decisionTable, Map<String, Object> inputVariables) {
        if (inputVariables == null) {
            inputVariables = new HashMap<String, Object>();
        }
        for (InputClause inputClause : decisionTable.getInputs()) {
            if (inputVariables.containsKey(inputClause.getInputExpression().getText()) || !"boolean".equals(inputClause.getInputExpression().getTypeRef())) continue;
            inputVariables.put(inputClause.getInputExpression().getText(), Boolean.FALSE);
        }
        for (OutputClause outputClause : decisionTable.getOutputs()) {
            if (inputVariables.containsKey(outputClause.getName()) && inputVariables.get(outputClause.getName()) != null) continue;
            if ("number".equals(outputClause.getTypeRef())) {
                inputVariables.put(outputClause.getName(), 0.0);
                continue;
            }
            if ("date".equals(outputClause.getTypeRef())) {
                inputVariables.put(outputClause.getName(), new Date());
                continue;
            }
            inputVariables.put(outputClause.getName(), "");
        }
        for (Map.Entry entry : inputVariables.entrySet()) {
            try {
                if (entry.getValue() instanceof org.joda.time.LocalDate) {
                    Date transformedDate = ((org.joda.time.LocalDate)entry.getValue()).toDate();
                    inputVariables.put((String)entry.getKey(), transformedDate);
                    continue;
                }
                if (entry.getValue() instanceof LocalDate) {
                    Date transformedDate = Date.from(((LocalDate)entry.getValue()).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                    inputVariables.put((String)entry.getKey(), transformedDate);
                    continue;
                }
                if (entry.getValue() instanceof Long || entry.getValue() instanceof Integer) {
                    BigInteger transformedNumber = new BigInteger(entry.getValue().toString());
                    inputVariables.put((String)entry.getKey(), transformedNumber);
                    continue;
                }
                if (entry.getValue() instanceof Double) {
                    BigDecimal transformedNumber = new BigDecimal((Double)entry.getValue());
                    inputVariables.put((String)entry.getKey(), transformedNumber);
                    continue;
                }
                if (!(entry.getValue() instanceof Float)) continue;
                double doubleValue = Double.parseDouble(entry.getValue().toString());
                BigDecimal transformedNumber = new BigDecimal(doubleValue);
                inputVariables.put((String)entry.getKey(), transformedNumber);
            }
            catch (Exception ex) {
                throw new FlowableException("error while transforming variable", (Throwable)ex);
            }
        }
    }
}

