/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.ExecuteDecisionContext;
import org.flowable.dmn.engine.impl.ExecuteDecisionBuilderImpl;
import org.flowable.dmn.engine.impl.cmd.AbstractExecuteDecisionCmd;
import org.flowable.dmn.model.DmnDefinition;

public class ExecuteDecisionWithAuditTrailCmd
extends AbstractExecuteDecisionCmd
implements Command<Void> {
    private static final long serialVersionUID = 1L;

    public ExecuteDecisionWithAuditTrailCmd(ExecuteDecisionBuilderImpl decisionBuilder) {
        super(decisionBuilder);
    }

    public ExecuteDecisionWithAuditTrailCmd(ExecuteDecisionContext executeDecisionContext) {
        super(executeDecisionContext);
    }

    public ExecuteDecisionWithAuditTrailCmd(String decisionKey, Map<String, Object> variables) {
        super(decisionKey, variables);
    }

    public ExecuteDecisionWithAuditTrailCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables) {
        this(decisionKey, variables);
        this.executeDecisionContext.setParentDeploymentId(parentDeploymentId);
    }

    public ExecuteDecisionWithAuditTrailCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables, String tenantId) {
        this(decisionKey, parentDeploymentId, variables);
        this.executeDecisionContext.setTenantId(tenantId);
    }

    public Void execute(CommandContext commandContext) {
        DmnDefinition definition;
        if (this.executeDecisionContext.getDecisionKey() == null) {
            throw new FlowableIllegalArgumentException("decisionKey is null");
        }
        try {
            definition = this.resolveDefinition();
        }
        catch (FlowableException e) {
            DecisionExecutionAuditContainer container = new DecisionExecutionAuditContainer();
            container.setFailed();
            container.setExceptionMessage(e.getMessage());
            this.executeDecisionContext.setDecisionExecution(container);
            return null;
        }
        this.execute(commandContext, definition);
        return null;
    }
}

