/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.deployer.ResourceNameUtil;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnResourceEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.DmnDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionRequirementsDiagramHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecisionRequirementsDiagramHelper.class);

    public DmnResourceEntity createDiagramForDecision(DecisionEntity decision, DmnDefinition dmnDefinition) {
        if (StringUtils.isEmpty((CharSequence)decision.getKey()) || StringUtils.isEmpty((CharSequence)decision.getResourceName())) {
            throw new IllegalStateException("Provided decision definition must have both key and resource name set.");
        }
        DmnResourceEntity resource = this.createResourceEntity();
        DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
        try {
            byte[] diagramBytes = IoUtil.readInputStream((InputStream)dmnEngineConfiguration.getDecisionRequirementsDiagramGenerator().generateDiagram(dmnDefinition, "png", dmnEngineConfiguration.getDecisionFontName(), dmnEngineConfiguration.getLabelFontName(), dmnEngineConfiguration.getAnnotationFontName(), dmnEngineConfiguration.getClassLoader()), null);
            String diagramResourceName = ResourceNameUtil.getDecisionRequirementsDiagramResourceName(decision.getResourceName(), decision.getKey(), "png");
            resource.setName(diagramResourceName);
            resource.setBytes(diagramBytes);
            resource.setDeploymentId(decision.getDeploymentId());
            resource.setGenerated(true);
        }
        catch (Throwable t) {
            LOGGER.warn("Error while generating decision requirements diagram, image will not be stored in repository", t);
            resource = null;
        }
        return resource;
    }

    protected DmnResourceEntity createResourceEntity() {
        return (DmnResourceEntity)CommandContextUtil.getDmnEngineConfiguration().getResourceEntityManager().create();
    }

    public boolean shouldCreateDiagram(DecisionEntity decision, EngineDeployment deployment) {
        if (deployment.isNew() && decision.hasGraphicalNotation() && CommandContextUtil.getDmnEngineConfiguration().isCreateDiagramOnDeploy()) {
            return ResourceNameUtil.getDecisionRequirementsDiagramResourceNameFromDeployment(decision, deployment.getResources()) == null;
        }
        return false;
    }
}

