/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.dmn.engine.impl.deployer.DmnResourceUtil;
import org.flowable.dmn.engine.impl.deployer.ParsedDeployment;
import org.flowable.dmn.engine.impl.parser.DmnParse;
import org.flowable.dmn.engine.impl.parser.DmnParseFactory;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedDeploymentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsedDeploymentBuilder.class);
    protected DmnDeploymentEntity deployment;
    protected DmnParseFactory dmnParseFactory;
    protected Map<String, Object> deploymentSettings;

    public ParsedDeploymentBuilder(DmnDeploymentEntity deployment, DmnParseFactory dmnParseFactory, Map<String, Object> deploymentSettings) {
        this.deployment = deployment;
        this.dmnParseFactory = dmnParseFactory;
        this.deploymentSettings = deploymentSettings;
    }

    public ParsedDeployment build() {
        ArrayList<DecisionEntity> decisions = new ArrayList<DecisionEntity>();
        LinkedHashMap<DecisionEntity, DmnParse> decisionToDmnParseMap = new LinkedHashMap<DecisionEntity, DmnParse>();
        LinkedHashMap<DecisionEntity, EngineResource> decisionToResourceMap = new LinkedHashMap<DecisionEntity, EngineResource>();
        for (EngineResource resource : this.deployment.getResources().values()) {
            if (!DmnResourceUtil.isDmnResource(resource.getName())) continue;
            LOGGER.debug("Processing DMN resource {}", (Object)resource.getName());
            DmnParse parse = this.createDmnParseFromResource(resource);
            this.processDI(parse.getDmnDefinition(), parse.getDecisions());
            for (DecisionEntity decision : parse.getDecisions()) {
                decisions.add(decision);
                decisionToDmnParseMap.put(decision, parse);
                decisionToResourceMap.put(decision, resource);
            }
        }
        return new ParsedDeployment(this.deployment, decisions, decisionToDmnParseMap, decisionToResourceMap);
    }

    protected DmnParse createDmnParseFromResource(EngineResource resource) {
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        DmnParse dmnParse = this.dmnParseFactory.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
        if (this.deploymentSettings != null) {
            if (this.deploymentSettings.containsKey("isDmnXsdValidationEnabled")) {
                dmnParse.setValidateSchema((Boolean)this.deploymentSettings.get("isDmnXsdValidationEnabled"));
            }
        } else {
            dmnParse.setValidateSchema(false);
        }
        dmnParse.execute(CommandContextUtil.getDmnEngineConfiguration());
        return dmnParse;
    }

    protected void processDI(DmnDefinition dmnDefinition, List<DecisionEntity> decisions) {
        if (decisions.isEmpty()) {
            return;
        }
        if (!dmnDefinition.getLocationMap().isEmpty()) {
            for (String dmnRef : dmnDefinition.getLocationMap().keySet()) {
                if (dmnDefinition.getDecisionById(dmnRef) != null || dmnDefinition.getDecisionServiceById(dmnRef) != null) continue;
                LOGGER.warn("Invalid reference in diagram interchange definition: could not find {}", (Object)dmnRef);
            }
            for (DecisionService decisionService : dmnDefinition.getDecisionServices()) {
                DecisionEntity decision = this.getDecision(decisionService.getId(), decisions);
                if (decision == null) continue;
                decision.setHasGraphicalNotation(true);
            }
        }
    }

    public DecisionEntity getDecision(String decisionKey, List<DecisionEntity> decisions) {
        for (DecisionEntity decision : decisions) {
            if (!decision.getKey().equals(decisionKey)) continue;
            return decision;
        }
        return null;
    }
}

