/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.api.RuleExecutionAuditContainer;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.hitpolicy.AbstractHitPolicy;
import org.flowable.dmn.engine.impl.hitpolicy.ComposeDecisionResultBehavior;
import org.flowable.dmn.engine.impl.hitpolicy.EvaluateRuleValidityBehavior;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.HitPolicy;

public class HitPolicyUnique
extends AbstractHitPolicy
implements EvaluateRuleValidityBehavior,
ComposeDecisionResultBehavior {
    @Override
    public String getHitPolicyName() {
        return HitPolicy.UNIQUE.getValue();
    }

    @Override
    public void evaluateRuleValidity(int ruleNumber, ELExecutionContext executionContext) {
        for (Map.Entry entry : executionContext.getAuditContainer().getRuleExecutions().entrySet()) {
            if (((Integer)entry.getKey()).equals(ruleNumber) || !((RuleExecutionAuditContainer)entry.getValue()).isValid().booleanValue()) continue;
            String hitPolicyViolatedMessage = String.format("HitPolicy %s violated; at least rule %d and rule %d are valid.", this.getHitPolicyName(), ruleNumber, entry.getKey());
            if (CommandContextUtil.getDmnEngineConfiguration().isStrictMode()) {
                ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(ruleNumber)).setExceptionMessage(hitPolicyViolatedMessage);
                ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(entry.getKey())).setExceptionMessage(hitPolicyViolatedMessage);
                throw new FlowableException("HitPolicy UNIQUE violated.");
            }
            ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(ruleNumber)).setValidationMessage(hitPolicyViolatedMessage);
            ((RuleExecutionAuditContainer)executionContext.getAuditContainer().getRuleExecutions().get(entry.getKey())).setValidationMessage(hitPolicyViolatedMessage);
            break;
        }
    }

    @Override
    public void composeDecisionResults(ELExecutionContext executionContext) {
        ArrayList<Map<String, Object>> ruleResults = new ArrayList<Map<String, Object>>(executionContext.getRuleResults().values());
        List<Map<String, Object>> decisionResult = null;
        if (ruleResults.size() > 1 && !CommandContextUtil.getDmnEngineConfiguration().isStrictMode()) {
            HashMap lastResult = new HashMap();
            for (Map map : ruleResults) {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    lastResult.put((String)entry.getKey(), entry.getValue());
                }
            }
            executionContext.getAuditContainer().setValidationMessage(String.format("HitPolicy %s violated; multiple valid rules. Setting last valid rule result as final result.", this.getHitPolicyName()));
            decisionResult = Collections.singletonList(lastResult);
        } else {
            decisionResult = ruleResults;
        }
        executionContext.getAuditContainer().setDecisionResult(decisionResult);
    }
}

