/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.engine.impl.cmd.GetDeploymentResourceCmd;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDeploymentDecisionRequirementsDiagramCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GetDeploymentDecisionRequirementsDiagramCmd.class);
    protected String decisionId;

    public GetDeploymentDecisionRequirementsDiagramCmd(String decisionId) {
        if (decisionId == null || decisionId.length() == 0) {
            throw new FlowableIllegalArgumentException("The decision id is mandatory, but '" + decisionId + "' has been provided.");
        }
        this.decisionId = decisionId;
    }

    public InputStream execute(CommandContext commandContext) {
        DecisionEntity decisionEntity = CommandContextUtil.getDmnEngineConfiguration(commandContext).getDeploymentManager().findDeployedDecisionById(this.decisionId);
        String deploymentId = decisionEntity.getDeploymentId();
        String resourceName = decisionEntity.getDiagramResourceName();
        if (resourceName == null) {
            LOGGER.info("Resource name is null! No decision requirements diagram stream exists.");
            return null;
        }
        return new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
    }
}

