/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.interceptor;

import java.util.Collection;
import org.flowable.common.engine.impl.agenda.AgendaOperationExecutionListener;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.flowable.dmn.engine.impl.agenda.DmnEngineAgenda;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnCommandInvoker
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnCommandInvoker.class);
    protected Collection<AgendaOperationExecutionListener> agendaOperationExecutionListeners;

    public DmnCommandInvoker(Collection<AgendaOperationExecutionListener> agendaOperationExecutionListeners) {
        this.agendaOperationExecutionListeners = agendaOperationExecutionListeners;
    }

    public <T> T execute(CommandConfig config, final Command<T> command, CommandExecutor commandExecutor) {
        final CommandContext commandContext = Context.getCommandContext();
        DmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        if (commandContext.isReused() && !agenda.isEmpty()) {
            commandContext.setResult(command.execute(commandContext));
        } else {
            agenda.planOperation(new Runnable(){

                @Override
                public void run() {
                    commandContext.setResult(command.execute(commandContext));
                }
            });
            this.executeOperations(commandContext);
        }
        return (T)commandContext.getResult();
    }

    protected void executeOperations(CommandContext commandContext) {
        DmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        while (!agenda.isEmpty()) {
            Runnable runnable = agenda.getNextOperation();
            this.executeExecutionListenersBeforeExecute(commandContext, runnable);
            try {
                this.executeOperation(commandContext, runnable);
            }
            catch (Throwable throwable) {
                this.executeExecutionListenersAfterException(commandContext, runnable, throwable);
                ExceptionUtil.sneakyThrow((Throwable)throwable);
            }
            this.executeExecutionListenersAfterExecute(commandContext, runnable);
        }
    }

    protected void executeExecutionListenersBeforeExecute(CommandContext commandContext, Runnable runnable) {
        if (this.agendaOperationExecutionListeners != null && !this.agendaOperationExecutionListeners.isEmpty()) {
            for (AgendaOperationExecutionListener listener : this.agendaOperationExecutionListeners) {
                listener.beforeExecute(commandContext, runnable);
            }
        }
    }

    protected void executeExecutionListenersAfterExecute(CommandContext commandContext, Runnable runnable) {
        if (this.agendaOperationExecutionListeners != null && !this.agendaOperationExecutionListeners.isEmpty()) {
            for (AgendaOperationExecutionListener listener : this.agendaOperationExecutionListeners) {
                listener.afterExecute(commandContext, runnable);
            }
        }
    }

    protected void executeExecutionListenersAfterException(CommandContext commandContext, Runnable runnable, Throwable throwable) {
        if (this.agendaOperationExecutionListeners != null && !this.agendaOperationExecutionListeners.isEmpty()) {
            for (AgendaOperationExecutionListener listener : this.agendaOperationExecutionListeners) {
                listener.afterExecuteException(commandContext, runnable, throwable);
            }
        }
    }

    protected void executeOperation(CommandContext commandContext, Runnable runnable) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing agenda operation {}", (Object)runnable);
        }
        runnable.run();
    }

    public void setNext(CommandInterceptor next) {
        throw new UnsupportedOperationException("CommandInvoker must be the last interceptor in the chain");
    }
}

