/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.joda.JodaDeprecationLogger;
import org.flowable.dmn.api.DecisionExecutionAuditContainer;
import org.flowable.dmn.api.ExecuteDecisionContext;
import org.flowable.dmn.engine.impl.audit.DecisionExecutionAuditUtil;
import org.flowable.dmn.engine.impl.el.ELExecutionContext;
import org.flowable.dmn.engine.impl.el.ExecutionVariableFactory;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.OutputClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELExecutionContextBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ELExecutionContextBuilder.class);

    public static ELExecutionContext build(DecisionService decisionService, ExecuteDecisionContext executeDecisionInfo) {
        ELExecutionContext executionContext = new ELExecutionContext();
        executionContext.setInstanceId(executeDecisionInfo.getInstanceId());
        executionContext.setScopeType(executeDecisionInfo.getScopeType());
        executionContext.setTenantId(executeDecisionInfo.getTenantId());
        executionContext.setAuditContainer((DecisionExecutionAuditContainer)DecisionExecutionAuditUtil.initializeDecisionServiceExecutionAudit(decisionService, executeDecisionInfo));
        return executionContext;
    }

    public static ELExecutionContext build(Decision decision, ExecuteDecisionContext executeDecisionInfo) {
        ELExecutionContext executionContext = new ELExecutionContext();
        executionContext.setInstanceId(executeDecisionInfo.getInstanceId());
        executionContext.setScopeType(executeDecisionInfo.getScopeType());
        executionContext.setTenantId(executeDecisionInfo.getTenantId());
        executionContext.setForceDMN11(decision.isForceDMN11());
        executionContext.setAuditContainer(DecisionExecutionAuditUtil.initializeDecisionExecutionAudit(decision, executeDecisionInfo));
        DecisionTable decisionTable = (DecisionTable)decision.getExpression();
        if (decisionTable.getOutputs() != null) {
            for (OutputClause outputClause : decisionTable.getOutputs()) {
                if (outputClause.getOutputValues() == null || outputClause.getOutputValues().getTextValues() == null) continue;
                executionContext.addOutputValues(outputClause.getName(), ExecutionVariableFactory.getExecutionVariables(outputClause.getTypeRef(), outputClause.getOutputValues().getTextValues()));
            }
        }
        if (decisionTable.getAggregation() != null) {
            executionContext.setAggregator(decisionTable.getAggregation());
        }
        Map inputVariables = executeDecisionInfo.getVariables();
        ELExecutionContextBuilder.preProcessInputVariables(decisionTable, inputVariables, executeDecisionInfo);
        executionContext.setStackVariables(inputVariables);
        LOGGER.debug("Execution Context created");
        return executionContext;
    }

    protected static void preProcessInputVariables(DecisionTable decisionTable, Map<String, Object> inputVariables, ExecuteDecisionContext executeDecisionInfo) {
        if (inputVariables == null) {
            inputVariables = new HashMap<String, Object>();
        }
        for (InputClause inputClause : decisionTable.getInputs()) {
            if (inputVariables.containsKey(inputClause.getInputExpression().getText()) || !"boolean".equals(inputClause.getInputExpression().getTypeRef())) continue;
            inputVariables.put(inputClause.getInputExpression().getText(), Boolean.FALSE);
        }
        for (OutputClause outputClause : decisionTable.getOutputs()) {
            if (inputVariables.containsKey(outputClause.getName()) && inputVariables.get(outputClause.getName()) != null) continue;
            if ("number".equals(outputClause.getTypeRef())) {
                inputVariables.put(outputClause.getName(), 0.0);
                continue;
            }
            if ("date".equals(outputClause.getTypeRef())) {
                inputVariables.put(outputClause.getName(), new Date());
                continue;
            }
            inputVariables.put(outputClause.getName(), "");
        }
        for (Map.Entry entry : inputVariables.entrySet()) {
            String inputVariableName = (String)entry.getKey();
            try {
                Object inputVariableValue = entry.getValue();
                if (inputVariableValue instanceof org.joda.time.LocalDate) {
                    JodaDeprecationLogger.LOGGER.warn("Using Joda-Time LocalDate has been deprecated and will be removed in a future version. Input variable {} from {} {} for decision table {} is a Joda-Time LocalDate. ", new Object[]{inputVariableName, executeDecisionInfo.getScopeType(), executeDecisionInfo.getInstanceId(), decisionTable.getId()});
                    Date transformedDate = ((org.joda.time.LocalDate)inputVariableValue).toDate();
                    inputVariables.put(inputVariableName, transformedDate);
                    continue;
                }
                if (inputVariableValue instanceof LocalDate) {
                    Date transformedDate = Date.from(((LocalDate)inputVariableValue).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
                    inputVariables.put(inputVariableName, transformedDate);
                    continue;
                }
                if (inputVariableValue instanceof Long || inputVariableValue instanceof Integer) {
                    BigInteger transformedNumber = new BigInteger(inputVariableValue.toString());
                    inputVariables.put(inputVariableName, transformedNumber);
                    continue;
                }
                if (inputVariableValue instanceof Double) {
                    BigDecimal transformedNumber = new BigDecimal((Double)inputVariableValue);
                    inputVariables.put(inputVariableName, transformedNumber);
                    continue;
                }
                if (!(inputVariableValue instanceof Float)) continue;
                double doubleValue = Double.parseDouble(inputVariableValue.toString());
                BigDecimal transformedNumber = new BigDecimal(doubleValue);
                inputVariables.put(inputVariableName, transformedNumber);
            }
            catch (Exception ex) {
                throw new FlowableException("error while transforming input variable " + inputVariableName + " for decision table " + decisionTable.getId(), (Throwable)ex);
            }
        }
    }
}

