/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.el.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.flowable.common.engine.impl.joda.JodaDeprecationLogger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    public static Date toDate(Object dateObject) {
        if (dateObject == null) {
            throw new IllegalArgumentException("date object cannot be empty");
        }
        if (dateObject instanceof Date) {
            return (Date)dateObject;
        }
        if (dateObject instanceof org.joda.time.LocalDate) {
            JodaDeprecationLogger.LOGGER.warn("Using Joda-Time LocalDate has been deprecated and will be removed in a future version.");
            return ((org.joda.time.LocalDate)dateObject).toDate();
        }
        if (dateObject instanceof LocalDate) {
            return Date.from(((LocalDate)dateObject).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        }
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        org.joda.time.LocalDate dateTime = dtf.parseLocalDate((String)dateObject);
        return dateTime.toDate();
    }

    public static Date addDate(Object startDate, Object years, Object months, Object days) {
        org.joda.time.LocalDate currentDate = new org.joda.time.LocalDate(startDate);
        currentDate = currentDate.plusYears(DateUtil.intValue(years).intValue());
        currentDate = currentDate.plusMonths(DateUtil.intValue(months).intValue());
        currentDate = currentDate.plusDays(DateUtil.intValue(days).intValue());
        return currentDate.toDate();
    }

    public static Date subtractDate(Object startDate, Object years, Object months, Object days) {
        org.joda.time.LocalDate currentDate = new org.joda.time.LocalDate(startDate);
        currentDate = currentDate.minusYears(DateUtil.intValue(years).intValue());
        currentDate = currentDate.minusMonths(DateUtil.intValue(months).intValue());
        currentDate = currentDate.minusDays(DateUtil.intValue(days).intValue());
        return currentDate.toDate();
    }

    public static Date now() {
        return new org.joda.time.LocalDate().toDate();
    }

    protected static Integer intValue(Object value) {
        Integer intValue = null;
        intValue = value instanceof Integer ? (Integer)value : Integer.valueOf(value.toString());
        return intValue;
    }
}

