/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.test;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.common.engine.impl.test.EnsureCleanDbUtils;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.test.DmnDeployment;
import org.flowable.dmn.engine.test.DmnDeploymentId;
import org.flowable.dmn.engine.test.DmnTestHelper;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalFlowableDmnExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    protected static final String ANNOTATION_DEPLOYMENT_ID_KEY = "deploymentIdFromDeploymentAnnotation";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
        DmnEngine dmnEngine = this.getDmnEngine(context);
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), DmnDeployment.class).ifPresent(deployment -> {
            String deploymentId = DmnTestHelper.annotationDeploymentSetUp(dmnEngine, context.getRequiredTestClass(), context.getRequiredTestMethod(), deployment);
            this.getStore(context).put((Object)(context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), (Object)deploymentId);
        });
    }

    public void afterEach(ExtensionContext context) {
        DmnEngine dmnEngine = this.getDmnEngine(context);
        dmnEngine.getDmnEngineConfiguration().getClock().reset();
        String deploymentIdFromAnnotation = (String)this.getStore(context).remove((Object)(context.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), String.class);
        if (deploymentIdFromAnnotation != null) {
            DmnTestHelper.annotationDeploymentTearDown(dmnEngine, deploymentIdFromAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
        }
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), EnsureCleanDb.class).ifPresent(ensureCleanDb -> EnsureCleanDbUtils.assertAndEnsureCleanDb((String)context.getDisplayName(), (Logger)this.logger, (AbstractEngineConfiguration)dmnEngine.getDmnEngineConfiguration(), (EnsureCleanDb)ensureCleanDb, (boolean)context.getExecutionException().isEmpty(), (Command)dmnEngine.getDmnEngineConfiguration().getSchemaManagementCmd()));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return DmnEngine.class.equals(parameterType) || parameterContext.isAnnotated(DmnDeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.isAnnotated(DmnDeploymentId.class)) {
            return this.getStore(extensionContext).get((Object)(extensionContext.getUniqueId() + ANNOTATION_DEPLOYMENT_ID_KEY), String.class);
        }
        return this.getDmnEngine(extensionContext);
    }

    protected abstract DmnEngine getDmnEngine(ExtensionContext var1);

    protected abstract ExtensionContext.Store getStore(ExtensionContext var1);
}

