/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.test;

import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Function;
import org.flowable.dmn.engine.DmnEngine;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.DmnEngines;
import org.flowable.dmn.engine.impl.test.InternalFlowableDmnExtension;
import org.flowable.dmn.engine.test.DmnConfigurationResource;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class PluggableFlowableDmnExtension
extends InternalFlowableDmnExtension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{PluggableFlowableDmnExtension.class});

    @Override
    protected DmnEngine getDmnEngine(ExtensionContext context) {
        String configurationResource = this.getConfigurationResource(context);
        return ((CloseableEngine)this.getStore((ExtensionContext)context).getOrComputeIfAbsent((Object)configurationResource, (Function<String, CloseableEngine>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, initializeDmnEngine(java.lang.String ), (Ljava/lang/String;)Lorg/flowable/dmn/engine/impl/test/PluggableFlowableDmnExtension$CloseableEngine;)((PluggableFlowableDmnExtension)this), CloseableEngine.class)).dmnEngine;
    }

    protected CloseableEngine initializeDmnEngine(String configurationResource) {
        this.logger.info("No cached dmn engine found for test. Retrieving engine from {}.", (Object)configurationResource);
        DmnEngineConfiguration dmnEngineConfiguration = DmnEngineConfiguration.createDmnEngineConfigurationFromResource(configurationResource);
        DmnEngine dmnEngine = dmnEngineConfiguration.buildDmnEngine();
        DmnEngines.setInitialized(true);
        return new CloseableEngine(dmnEngine);
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), DmnConfigurationResource.class).map(DmnConfigurationResource::value).orElse("flowable.dmn.cfg.xml");
    }

    @Override
    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }

    protected static class CloseableEngine
    implements ExtensionContext.Store.CloseableResource {
        protected final DmnEngine dmnEngine;

        protected CloseableEngine(DmnEngine dmnEngine) {
            this.dmnEngine = dmnEngine;
        }

        public void close() throws Throwable {
            if (this.dmnEngine != null) {
                this.dmnEngine.close();
            }
        }
    }

    protected record ConfigurationResource(String resource, String engineName) {
    }
}

