/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.image.impl;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.image.DecisionRequirementsDiagramGenerator;
import org.flowable.dmn.image.exception.FlowableImageException;
import org.flowable.dmn.image.impl.DefaultDecisionRequirementsDiagramCanvas;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnElementReference;
import org.flowable.dmn.model.GraphicInfo;
import org.flowable.dmn.model.InformationRequirement;
import org.flowable.dmn.model.NamedElement;

public class DefaultDecisionRequirementsDiagramGenerator
implements DecisionRequirementsDiagramGenerator {
    protected Map<Class<? extends NamedElement>, ActivityDrawInstruction> elementDrawInstructions = new HashMap<Class<? extends NamedElement>, ActivityDrawInstruction>();

    public DefaultDecisionRequirementsDiagramGenerator() {
        this(1.0);
    }

    public DefaultDecisionRequirementsDiagramGenerator(final double scaleFactor) {
        this.elementDrawInstructions.put(Decision.class, new ActivityDrawInstruction(){

            @Override
            public void draw(DefaultDecisionRequirementsDiagramCanvas decisionRequirementsDiagramCanvas, DmnDefinition dmnDefinition, NamedElement NamedElement2) {
                GraphicInfo graphicInfo = dmnDefinition.getGraphicInfo(NamedElement2.getId());
                decisionRequirementsDiagramCanvas.drawDecision(NamedElement2.getName(), graphicInfo, scaleFactor);
            }
        });
    }

    @Override
    public InputStream generateDiagram(DmnDefinition dmnDefinition, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.generateDecisionRequirementsDiagram(dmnDefinition, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor).generateImage(imageType);
    }

    @Override
    public InputStream generateDiagram(DmnDefinition dmnDefinition, String imageType) {
        return this.generateDiagram(dmnDefinition, imageType, null, null, null, null, 1.0);
    }

    @Override
    public InputStream generateDiagram(DmnDefinition dmnDefinition, String imageType, double scaleFactor) {
        return this.generateDiagram(dmnDefinition, imageType, null, null, null, null, scaleFactor);
    }

    @Override
    public InputStream generateDiagram(DmnDefinition dmnDefinition, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        return this.generateDiagram(dmnDefinition, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader, 1.0);
    }

    @Override
    public InputStream generatePngDiagram(DmnDefinition dmnDefinition) {
        return this.generatePngDiagram(dmnDefinition, 1.0);
    }

    @Override
    public InputStream generatePngDiagram(DmnDefinition dmnDefinition, double scaleFactor) {
        return this.generateDiagram(dmnDefinition, "png", scaleFactor);
    }

    @Override
    public InputStream generateJpgDiagram(DmnDefinition dmnDefinition) {
        return this.generateJpgDiagram(dmnDefinition, 1.0);
    }

    @Override
    public InputStream generateJpgDiagram(DmnDefinition dmnDefinition, double scaleFactor) {
        return this.generateDiagram(dmnDefinition, "jpg", scaleFactor);
    }

    public BufferedImage generateImage(DmnDefinition dmnDefinition, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        return this.generateDecisionRequirementsDiagram(dmnDefinition, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader, scaleFactor).generateBufferedImage(imageType);
    }

    public BufferedImage generateImage(DmnDefinition dmnDefinition, String imageType, double scaleFactor) {
        return this.generateImage(dmnDefinition, imageType, null, null, null, null, scaleFactor);
    }

    @Override
    public BufferedImage generatePngImage(DmnDefinition dmnDefinition, double scaleFactor) {
        return this.generateImage(dmnDefinition, "png", scaleFactor);
    }

    protected DefaultDecisionRequirementsDiagramCanvas generateDecisionRequirementsDiagram(DmnDefinition dmnDefinition, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader, double scaleFactor) {
        this.prepareDmnDefinition(dmnDefinition);
        DefaultDecisionRequirementsDiagramCanvas decisionRequirementsDiagramCanvas = DefaultDecisionRequirementsDiagramGenerator.initDecisionRequirementsDiagramCanvas(dmnDefinition, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
        for (DecisionService decisionService : dmnDefinition.getDecisionServices()) {
            Decision decision;
            GraphicInfo decisionServiceInfo = dmnDefinition.getGraphicInfo(decisionService.getId());
            if (decisionServiceInfo == null) {
                throw new FlowableImageException("Could not find graphic info for decision service: " + decisionService.getId());
            }
            List decisionServiceDividerInfos = dmnDefinition.getDecisionServiceDividerGraphicInfo(decisionService.getId());
            decisionRequirementsDiagramCanvas.drawDecisionService(decisionService.getName(), decisionServiceInfo, decisionServiceDividerInfos, scaleFactor);
            for (DmnElementReference decisionRef : decisionService.getOutputDecisions()) {
                decision = dmnDefinition.getDecisionById(decisionRef.getParsedId());
                this.drawDecision(decisionRequirementsDiagramCanvas, dmnDefinition, decision, scaleFactor);
                for (InformationRequirement informationRequirement : decision.getRequiredDecisions()) {
                    this.drawInformationRequirement(decisionRequirementsDiagramCanvas, dmnDefinition, informationRequirement, decision, scaleFactor);
                }
            }
            for (DmnElementReference decisionRef : decisionService.getEncapsulatedDecisions()) {
                decision = dmnDefinition.getDecisionById(decisionRef.getParsedId());
                this.drawDecision(decisionRequirementsDiagramCanvas, dmnDefinition, decision, scaleFactor);
                for (InformationRequirement informationRequirement : decision.getRequiredDecisions()) {
                    this.drawInformationRequirement(decisionRequirementsDiagramCanvas, dmnDefinition, informationRequirement, decision, scaleFactor);
                }
            }
        }
        return decisionRequirementsDiagramCanvas;
    }

    protected void prepareDmnDefinition(DmnDefinition dmnDefinition) {
        ArrayList allGraphicInfos = new ArrayList();
        if (dmnDefinition.getLocationMap() != null) {
            allGraphicInfos.addAll(dmnDefinition.getLocationMap().values());
        }
        if (dmnDefinition.getFlowLocationMap() != null) {
            for (List flowGraphicInfos : dmnDefinition.getFlowLocationMap().values()) {
                allGraphicInfos.addAll(flowGraphicInfos);
            }
        }
        if (allGraphicInfos.size() > 0) {
            boolean needsTranslationX = false;
            boolean needsTranslationY = false;
            double lowestX = 0.0;
            double lowestY = 0.0;
            for (GraphicInfo graphicInfo : allGraphicInfos) {
                double x = graphicInfo.getX();
                double y = graphicInfo.getY();
                if (x < lowestX) {
                    needsTranslationX = true;
                    lowestX = x;
                }
                if (!(y < lowestY)) continue;
                needsTranslationY = true;
                lowestY = y;
            }
            if (needsTranslationX || needsTranslationY) {
                double translationX = Math.abs(lowestX);
                double translationY = Math.abs(lowestY);
                for (GraphicInfo graphicInfo : allGraphicInfos) {
                    if (needsTranslationX) {
                        graphicInfo.setX(graphicInfo.getX() + translationX);
                    }
                    if (!needsTranslationY) continue;
                    graphicInfo.setY(graphicInfo.getY() + translationY);
                }
            }
        }
    }

    protected void drawDecision(DefaultDecisionRequirementsDiagramCanvas decisionRequirementsDiagramCanvas, DmnDefinition dmnDefinition, Decision decision, double scaleFactor) {
        ActivityDrawInstruction drawInstruction = this.elementDrawInstructions.get(decision.getClass());
        if (drawInstruction != null) {
            drawInstruction.draw(decisionRequirementsDiagramCanvas, dmnDefinition, (NamedElement)decision);
        }
    }

    protected void drawInformationRequirement(DefaultDecisionRequirementsDiagramCanvas decisionRequirementsDiagramCanvas, DmnDefinition dmnDefinition, InformationRequirement informationRequirement, Decision targetDecision, double scaleFactor) {
        Decision sourceDecision = dmnDefinition.getDecisionById(informationRequirement.getRequiredDecision().getParsedId());
        List<GraphicInfo> graphicInfoList = dmnDefinition.getFlowLocationGraphicInfo(informationRequirement.getId());
        if (graphicInfoList != null && graphicInfoList.size() > 0) {
            graphicInfoList = DefaultDecisionRequirementsDiagramGenerator.connectionPerfectionizer(decisionRequirementsDiagramCanvas, dmnDefinition, (DmnElement)sourceDecision, (DmnElement)targetDecision, graphicInfoList);
            int[] xPoints = new int[graphicInfoList.size()];
            int[] yPoints = new int[graphicInfoList.size()];
            for (int i = 1; i < graphicInfoList.size(); ++i) {
                GraphicInfo graphicInfo = graphicInfoList.get(i);
                GraphicInfo previousGraphicInfo = graphicInfoList.get(i - 1);
                if (i == 1) {
                    xPoints[0] = (int)previousGraphicInfo.getX();
                    yPoints[0] = (int)previousGraphicInfo.getY();
                }
                xPoints[i] = (int)graphicInfo.getX();
                yPoints[i] = (int)graphicInfo.getY();
            }
            decisionRequirementsDiagramCanvas.drawInformationRequirement(xPoints, yPoints, scaleFactor);
        }
    }

    protected static List<GraphicInfo> connectionPerfectionizer(DefaultDecisionRequirementsDiagramCanvas processDiagramCanvas, DmnDefinition dmnDefinition, DmnElement sourceElement, DmnElement targetElement, List<GraphicInfo> graphicInfoList) {
        GraphicInfo sourceGraphicInfo = dmnDefinition.getGraphicInfo(sourceElement.getId());
        GraphicInfo targetGraphicInfo = dmnDefinition.getGraphicInfo(targetElement.getId());
        DefaultDecisionRequirementsDiagramCanvas.SHAPE_TYPE sourceShapeType = DefaultDecisionRequirementsDiagramGenerator.getShapeType(sourceElement);
        DefaultDecisionRequirementsDiagramCanvas.SHAPE_TYPE targetShapeType = DefaultDecisionRequirementsDiagramGenerator.getShapeType(targetElement);
        return processDiagramCanvas.connectionPerfectionizer(sourceShapeType, targetShapeType, sourceGraphicInfo, targetGraphicInfo, graphicInfoList);
    }

    protected static DefaultDecisionRequirementsDiagramCanvas.SHAPE_TYPE getShapeType(DmnElement baseElement) {
        if (baseElement instanceof Decision) {
            return DefaultDecisionRequirementsDiagramCanvas.SHAPE_TYPE.Rectangle;
        }
        return null;
    }

    protected static GraphicInfo getLineCenter(List<GraphicInfo> graphicInfoList) {
        GraphicInfo gi = new GraphicInfo();
        int[] xPoints = new int[graphicInfoList.size()];
        int[] yPoints = new int[graphicInfoList.size()];
        double length = 0.0;
        double[] lengths = new double[graphicInfoList.size()];
        lengths[0] = 0.0;
        for (int i = 1; i < graphicInfoList.size(); ++i) {
            GraphicInfo graphicInfo = graphicInfoList.get(i);
            GraphicInfo previousGraphicInfo = graphicInfoList.get(i - 1);
            if (i == 1) {
                xPoints[0] = (int)previousGraphicInfo.getX();
                yPoints[0] = (int)previousGraphicInfo.getY();
            }
            xPoints[i] = (int)graphicInfo.getX();
            yPoints[i] = (int)graphicInfo.getY();
            lengths[i] = length += Math.sqrt(Math.pow((int)graphicInfo.getX() - (int)previousGraphicInfo.getX(), 2.0) + Math.pow((int)graphicInfo.getY() - (int)previousGraphicInfo.getY(), 2.0));
        }
        double m = length / 2.0;
        int p1 = 0;
        int p2 = 1;
        int i = 1;
        while (i < lengths.length) {
            double len = lengths[i];
            p1 = i - 1;
            p2 = i++;
            if (len > m) break;
        }
        GraphicInfo graphicInfo1 = graphicInfoList.get(p1);
        GraphicInfo graphicInfo2 = graphicInfoList.get(p2);
        double AB = (int)graphicInfo2.getX() - (int)graphicInfo1.getX();
        double OA = (int)graphicInfo2.getY() - (int)graphicInfo1.getY();
        double OB = lengths[p2] - lengths[p1];
        double ob = m - lengths[p1];
        double ab = AB * ob / OB;
        double oa = OA * ob / OB;
        double mx = graphicInfo1.getX() + ab;
        double my = graphicInfo1.getY() + oa;
        gi.setX(mx);
        gi.setY(my);
        return gi;
    }

    protected static DefaultDecisionRequirementsDiagramCanvas initDecisionRequirementsDiagramCanvas(DmnDefinition dmnDefinition, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        double minX = Double.MAX_VALUE;
        double maxX = 0.0;
        double minY = Double.MAX_VALUE;
        double maxY = 0.0;
        for (DecisionService decisionService : dmnDefinition.getDecisionServices()) {
            GraphicInfo decisionServiceInfo = dmnDefinition.getGraphicInfo(decisionService.getId());
            if (decisionServiceInfo == null) {
                throw new FlowableImageException("Could not find graphic info for decision service: " + decisionService.getId());
            }
            if (decisionServiceInfo.getX() + decisionServiceInfo.getWidth() > maxX) {
                maxX = decisionServiceInfo.getX() + decisionServiceInfo.getWidth();
            }
            if (decisionServiceInfo.getX() < minX) {
                minX = decisionServiceInfo.getX();
            }
            if (decisionServiceInfo.getY() + decisionServiceInfo.getHeight() > maxY) {
                maxY = decisionServiceInfo.getY() + decisionServiceInfo.getHeight();
            }
            if (!(decisionServiceInfo.getY() < minY)) continue;
            minY = decisionServiceInfo.getY();
        }
        return new DefaultDecisionRequirementsDiagramCanvas((int)maxX + 10, (int)maxY + 10, (int)minX, (int)minY, imageType, activityFontName, labelFontName, annotationFontName, customClassLoader);
    }

    public Map<Class<? extends NamedElement>, ActivityDrawInstruction> getElementDrawInstructions() {
        return this.elementDrawInstructions;
    }

    public void setElementDrawInstructions(Map<Class<? extends NamedElement>, ActivityDrawInstruction> elementDrawInstructions) {
        this.elementDrawInstructions = elementDrawInstructions;
    }

    protected static interface ActivityDrawInstruction {
        public void draw(DefaultDecisionRequirementsDiagramCanvas var1, DmnDefinition var2, NamedElement var3);
    }
}

