/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnDeploymentQuery;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseDecisionResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    protected DmnDecision getDecisionFromRequest(String decisionId) {
        DmnDecision decision = this.dmnRepositoryService.getDecision(decisionId);
        if (decision == null) {
            throw new FlowableObjectNotFoundException("Could not find a decision with id '" + decisionId + "'.");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDecisionTableInfoById(decision);
        }
        return decision;
    }

    protected byte[] getDeploymentResourceData(String deploymentId, String resourceId, HttpServletResponse response) {
        List resourceList;
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("No deployment id provided");
        }
        if (resourceId == null) {
            throw new FlowableIllegalArgumentException("No resource id provided");
        }
        DmnDeploymentQuery deploymentQuery = this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId);
        DmnDeployment deployment = (DmnDeployment)deploymentQuery.singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a deployment with id '" + deploymentId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        if ((resourceList = this.dmnRepositoryService.getDeploymentResourceNames(deploymentId)).contains(resourceId)) {
            byte[] byArray;
            block13: {
                String contentType = this.contentTypeResolver.resolveContentType(resourceId);
                response.setContentType(contentType);
                InputStream resourceStream = this.dmnRepositoryService.getResourceAsStream(deploymentId, resourceId);
                try {
                    byArray = IOUtils.toByteArray((InputStream)resourceStream);
                    if (resourceStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceStream != null) {
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new FlowableException("Error converting resource stream", (Throwable)e);
                    }
                }
                resourceStream.close();
            }
            return byArray;
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with id '" + resourceId + "' in deployment '" + deploymentId);
    }
}

