/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.history;

import jakarta.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.dmn.api.DmnHistoricDecisionExecution;
import org.flowable.dmn.api.DmnHistoricDecisionExecutionQuery;
import org.flowable.dmn.api.DmnHistoryService;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BaseHistoricDecisionExecutionResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnHistoryService dmnHistoryService;
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    protected DmnHistoricDecisionExecution getHistoricDecisionExecutionFromRequest(String decisionExecutionId) {
        DmnHistoricDecisionExecutionQuery historicDecisionExecutionQuery = this.dmnHistoryService.createHistoricDecisionExecutionQuery().id(decisionExecutionId);
        DmnHistoricDecisionExecution decisionExecution = (DmnHistoricDecisionExecution)historicDecisionExecutionQuery.singleResult();
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDecisionHistoryInfoById(decisionExecution);
        }
        if (decisionExecution == null) {
            throw new FlowableObjectNotFoundException("Could not find a decision execution with id '" + decisionExecutionId + "'");
        }
        return decisionExecution;
    }

    protected String getExecutionAuditData(String decisionExecutionId, HttpServletResponse response) {
        if (decisionExecutionId == null) {
            throw new FlowableIllegalArgumentException("No decision execution id provided");
        }
        DmnHistoricDecisionExecution decisionExecution = this.getHistoricDecisionExecutionFromRequest(decisionExecutionId);
        response.setContentType("application/json");
        return decisionExecution.getExecutionJson();
    }
}

