/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.spring.autodeployment;

import org.flowable.dmn.api.DmnDeploymentBuilder;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.spring.autodeployment.AbstractAutoDeploymentStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class DefaultAutoDeploymentStrategy
extends AbstractAutoDeploymentStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAutoDeploymentStrategy.class);
    public static final String DEPLOYMENT_MODE = "default";

    @Override
    protected String getDeploymentMode() {
        return DEPLOYMENT_MODE;
    }

    @Override
    public void deployResources(String deploymentNameHint, Resource[] resources, DmnRepositoryService repositoryService) {
        try {
            DmnDeploymentBuilder deploymentBuilder = repositoryService.createDeployment().enableDuplicateFiltering().name(deploymentNameHint);
            for (Resource resource : resources) {
                deploymentBuilder.addInputStream(this.determineResourceName(resource), resource.getInputStream());
            }
            deploymentBuilder.deploy();
        }
        catch (Exception e) {
            LOGGER.warn("Exception while autodeploying DMN definitions. This exception can be ignored if the root cause indicates a unique constraint violation, which is typically caused by two (or more) servers booting up at the exact same time and deploying the same definitions. ", (Throwable)e);
        }
    }
}

