/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.converter.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.converter.child.InputClauseParser;
import org.flowable.dmn.converter.child.InputEntryParser;
import org.flowable.dmn.converter.child.InputExpressionParser;
import org.flowable.dmn.converter.child.OutputClauseParser;
import org.flowable.dmn.converter.child.OutputEntryParser;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnExtensionAttribute;
import org.flowable.dmn.model.DmnExtensionElement;
import org.flowable.dmn.xml.constants.DmnXMLConstants;

public class DmnXMLUtil
implements DmnXMLConstants {
    private static Map<String, BaseChildElementParser> genericChildParserMap = new HashMap<String, BaseChildElementParser>();

    private static void addGenericParser(BaseChildElementParser parser) {
        genericChildParserMap.put(parser.getElementName(), parser);
    }

    public static void addXMLLocation(DmnElement element, XMLStreamReader xtr) {
        Location location = xtr.getLocation();
    }

    public static void parseChildElements(String elementName, DmnElement parentElement, XMLStreamReader xtr, Map<String, BaseChildElementParser> childParsers, DecisionTable decisionTable) throws Exception {
        HashMap<String, BaseChildElementParser> localParserMap = new HashMap<String, BaseChildElementParser>(genericChildParserMap);
        if (childParsers != null) {
            localParserMap.putAll(childParsers);
        }
        boolean inExtensionElements = false;
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if ("extensionElements".equals(xtr.getLocalName())) {
                    inExtensionElements = true;
                    continue;
                }
                if (localParserMap.containsKey(xtr.getLocalName())) {
                    BaseChildElementParser childParser = (BaseChildElementParser)localParserMap.get(xtr.getLocalName());
                    if (inExtensionElements && !childParser.accepts(parentElement)) {
                        DmnExtensionElement extensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                        parentElement.addExtensionElement(extensionElement);
                        continue;
                    }
                    ((BaseChildElementParser)localParserMap.get(xtr.getLocalName())).parseChildElement(xtr, parentElement, decisionTable);
                    continue;
                }
                if (!inExtensionElements) continue;
                DmnExtensionElement extensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                parentElement.addExtensionElement(extensionElement);
                continue;
            }
            if (!xtr.isEndElement()) continue;
            if ("extensionElements".equals(xtr.getLocalName())) {
                inExtensionElements = false;
                continue;
            }
            if (!elementName.equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
    }

    public static void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)value) && !"null".equalsIgnoreCase(value)) {
            xtw.writeAttribute(attributeName, value);
        }
    }

    public static void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            xtw.writeAttribute("flowable", "http://flowable.org/dmn", attributeName, value);
        }
    }

    public static DmnExtensionElement parseExtensionElement(XMLStreamReader xtr) throws Exception {
        DmnExtensionElement extensionElement = new DmnExtensionElement();
        extensionElement.setName(xtr.getLocalName());
        if (StringUtils.isNotEmpty((CharSequence)xtr.getNamespaceURI())) {
            extensionElement.setNamespace(xtr.getNamespaceURI());
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getPrefix())) {
            extensionElement.setNamespacePrefix(xtr.getPrefix());
        }
        for (int i = 0; i < xtr.getAttributeCount(); ++i) {
            DmnExtensionAttribute extensionAttribute = new DmnExtensionAttribute();
            extensionAttribute.setName(xtr.getAttributeLocalName(i));
            extensionAttribute.setValue(xtr.getAttributeValue(i));
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeNamespace(i))) {
                extensionAttribute.setNamespace(xtr.getAttributeNamespace(i));
            }
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributePrefix(i))) {
                extensionAttribute.setNamespacePrefix(xtr.getAttributePrefix(i));
            }
            extensionElement.addAttribute(extensionAttribute);
        }
        boolean readyWithExtensionElement = false;
        while (!readyWithExtensionElement && xtr.hasNext()) {
            xtr.next();
            if (xtr.isCharacters() || 12 == xtr.getEventType()) {
                if (!StringUtils.isNotEmpty((CharSequence)xtr.getText().trim())) continue;
                extensionElement.setElementText(xtr.getText().trim());
                continue;
            }
            if (xtr.isStartElement()) {
                DmnExtensionElement childExtensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                extensionElement.addChildElement(childExtensionElement);
                continue;
            }
            if (!xtr.isEndElement() || !extensionElement.getName().equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithExtensionElement = true;
        }
        return extensionElement;
    }

    public static void writeElementDescription(DmnElement dmnElement, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)dmnElement.getDescription()) && !"null".equalsIgnoreCase(dmnElement.getDescription())) {
            xtw.writeStartElement("description");
            xtw.writeCharacters(dmnElement.getDescription());
            xtw.writeEndElement();
        }
    }

    public static void writeExtensionElements(DmnElement dmnElement, XMLStreamWriter xtw) throws Exception {
        if (DmnXMLUtil.writeExtensionElements(dmnElement, false, xtw)) {
            xtw.writeEndElement();
        }
    }

    public static boolean writeExtensionElements(DmnElement dmnElement, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        return DmnXMLUtil.writeExtensionElements(dmnElement, didWriteExtensionStartElement, null, xtw);
    }

    public static boolean writeExtensionElements(DmnElement dmnElement, boolean didWriteExtensionStartElement, Map<String, String> namespaceMap, XMLStreamWriter xtw) throws Exception {
        if (!dmnElement.getExtensionElements().isEmpty()) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, String>();
            }
            for (List extensionElements : dmnElement.getExtensionElements().values()) {
                for (DmnExtensionElement extensionElement : extensionElements) {
                    DmnXMLUtil.writeExtensionElement(extensionElement, namespaceMap, xtw);
                }
            }
        }
        return didWriteExtensionStartElement;
    }

    protected static void writeExtensionElement(DmnExtensionElement extensionElement, Map<String, String> namespaceMap, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)extensionElement.getName())) {
            HashMap<String, String> localNamespaceMap = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)extensionElement.getNamespace())) {
                if (StringUtils.isNotEmpty((CharSequence)extensionElement.getNamespacePrefix())) {
                    xtw.writeStartElement(extensionElement.getNamespacePrefix(), extensionElement.getName(), extensionElement.getNamespace());
                    if (!namespaceMap.containsKey(extensionElement.getNamespacePrefix()) || !namespaceMap.get(extensionElement.getNamespacePrefix()).equals(extensionElement.getNamespace())) {
                        xtw.writeNamespace(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                        namespaceMap.put(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                        localNamespaceMap.put(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                    }
                } else {
                    xtw.writeStartElement(extensionElement.getNamespace(), extensionElement.getName());
                }
            } else {
                xtw.writeStartElement(extensionElement.getName());
            }
            for (List attributes : extensionElement.getAttributes().values()) {
                for (DmnExtensionAttribute attribute : attributes) {
                    if (!StringUtils.isNotEmpty((CharSequence)attribute.getName()) || attribute.getValue() == null) continue;
                    if (StringUtils.isNotEmpty((CharSequence)attribute.getNamespace())) {
                        if (StringUtils.isNotEmpty((CharSequence)attribute.getNamespacePrefix())) {
                            if (!namespaceMap.containsKey(attribute.getNamespacePrefix()) || !namespaceMap.get(attribute.getNamespacePrefix()).equals(attribute.getNamespace())) {
                                xtw.writeNamespace(attribute.getNamespacePrefix(), attribute.getNamespace());
                                namespaceMap.put(attribute.getNamespacePrefix(), attribute.getNamespace());
                            }
                            xtw.writeAttribute(attribute.getNamespacePrefix(), attribute.getNamespace(), attribute.getName(), attribute.getValue());
                            continue;
                        }
                        xtw.writeAttribute(attribute.getNamespace(), attribute.getName(), attribute.getValue());
                        continue;
                    }
                    xtw.writeAttribute(attribute.getName(), attribute.getValue());
                }
            }
            if (extensionElement.getElementText() != null) {
                xtw.writeCharacters(extensionElement.getElementText());
            } else {
                for (List childElements : extensionElement.getChildElements().values()) {
                    for (DmnExtensionElement childElement : childElements) {
                        DmnXMLUtil.writeExtensionElement(childElement, namespaceMap, xtw);
                    }
                }
            }
            for (String prefix : localNamespaceMap.keySet()) {
                namespaceMap.remove(prefix);
            }
            xtw.writeEndElement();
        }
    }

    static {
        DmnXMLUtil.addGenericParser(new InputClauseParser());
        DmnXMLUtil.addGenericParser(new OutputClauseParser());
        DmnXMLUtil.addGenericParser(new InputEntryParser());
        DmnXMLUtil.addGenericParser(new OutputEntryParser());
        DmnXMLUtil.addGenericParser(new InputExpressionParser());
    }
}

