/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.converter.util.DmnXMLUtil;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnExtensionElement;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.RuleInputClauseContainer;
import org.flowable.dmn.model.UnaryTests;

public class InputEntryParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "inputEntry";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parseChildElement(XMLStreamReader xtr, DmnElement parentElement, DecisionTable decisionTable) throws Exception {
        if (!(parentElement instanceof DecisionRule)) {
            return;
        }
        DecisionRule rule = (DecisionRule)parentElement;
        UnaryTests inputEntry = new UnaryTests();
        inputEntry.setId(xtr.getAttributeValue(null, "id"));
        boolean readyWithInputEntry = false;
        try {
            block2: while (!readyWithInputEntry && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "text".equalsIgnoreCase(xtr.getLocalName())) {
                    inputEntry.setText(xtr.getElementText());
                    continue;
                }
                if (!xtr.isStartElement() || !"extensionElements".equals(xtr.getLocalName())) {
                    if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                    readyWithInputEntry = true;
                    continue;
                }
                while (xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement()) {
                        DmnExtensionElement extensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                        inputEntry.addExtensionElement(extensionElement);
                        continue;
                    }
                    if (!xtr.isEndElement() || !"extensionElements".equals(xtr.getLocalName())) continue;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing input entry", (Throwable)e);
        }
        InputClause inputClause = null;
        if (decisionTable.getInputs() != null && decisionTable.getInputs().get(rule.getInputEntries().size()) != null) {
            inputClause = (InputClause)decisionTable.getInputs().get(rule.getInputEntries().size());
        }
        if (inputClause == null) {
            LOGGER.warn("Error determine output clause for position: {}", (Object)decisionTable.getInputs());
        }
        RuleInputClauseContainer ruleInputClauseContainer = new RuleInputClauseContainer();
        ruleInputClauseContainer.setInputClause(inputClause);
        ruleInputClauseContainer.setInputEntry(inputEntry);
        rule.addInputEntry(ruleInputClauseContainer);
    }
}

