/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.converter.child;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.model.UnaryTests;

public class OutputValuesParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "outputValues";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, DmnElement parentElement, Decision decision) throws Exception {
        if (!(parentElement instanceof OutputClause)) {
            return;
        }
        OutputClause clause = (OutputClause)parentElement;
        UnaryTests outputValues = new UnaryTests();
        boolean readyWithOutputValues = false;
        try {
            while (!readyWithOutputValues && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "text".equalsIgnoreCase(xtr.getLocalName())) {
                    String outputValuesText = xtr.getElementText();
                    outputValues.setTextValues(this.splitAndFormatOutputValues(outputValuesText));
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithOutputValues = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing output values", (Throwable)e);
        }
        clause.setOutputValues(outputValues);
    }

    public List<Object> splitAndFormatOutputValues(String outputValuesText) {
        int subEnd;
        int subStart;
        if (StringUtils.isEmpty((CharSequence)outputValuesText)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int start = 0;
        boolean inQuotes = false;
        for (int current = 0; current < outputValuesText.length(); ++current) {
            if (outputValuesText.charAt(current) == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (outputValuesText.charAt(current) != ',' || inQuotes) continue;
            subStart = this.getSubStringStartPos(start, outputValuesText);
            subEnd = this.getSubStringEndPos(current, outputValuesText);
            result.add(outputValuesText.substring(subStart, subEnd));
            start = current + 1;
            if (outputValuesText.charAt(start) != ' ') continue;
            ++start;
        }
        subStart = this.getSubStringStartPos(start, outputValuesText);
        subEnd = this.getSubStringEndPos(outputValuesText.length(), outputValuesText);
        result.add(outputValuesText.substring(subStart, subEnd));
        return result;
    }

    protected int getSubStringStartPos(int initialStart, String searchString) {
        if (searchString.charAt(initialStart) == '\"') {
            return initialStart + 1;
        }
        return initialStart;
    }

    protected int getSubStringEndPos(int initialEnd, String searchString) {
        if (searchString.charAt(initialEnd - 1) == '\"') {
            return initialEnd - 1;
        }
        return initialEnd;
    }
}

