/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.xml.converter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DiEdge;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnDiDiagram;
import org.flowable.dmn.model.DmnDiEdge;
import org.flowable.dmn.model.DmnDiShape;

public class ConversionHelper {
    protected DmnDefinition dmnDefinition;
    protected Decision currentDecision;
    protected DmnDiDiagram currentDiDiagram;
    protected DmnDiShape currentDiShape;
    protected DiEdge currentDiEdge;
    protected List<DmnDiDiagram> diDiagrams = new ArrayList<DmnDiDiagram>();
    protected Map<String, List<DmnDiShape>> diShapes = new LinkedHashMap<String, List<DmnDiShape>>();
    protected Map<String, List<DmnDiEdge>> diEdges = new LinkedHashMap<String, List<DmnDiEdge>>();

    public DmnDefinition getDmnDefinition() {
        return this.dmnDefinition;
    }

    public void setDmnDefinition(DmnDefinition dmnDefinition) {
        this.dmnDefinition = dmnDefinition;
    }

    public Decision getCurrentDecision() {
        return this.currentDecision;
    }

    public void setCurrentDecision(Decision currentDecision) {
        this.currentDecision = currentDecision;
    }

    public void addDiDiagram(DmnDiDiagram diDiagram) {
        this.diDiagrams.add(diDiagram);
        this.setCurrentDiDiagram(diDiagram);
    }

    public void addDiShape(DmnDiShape diShape) {
        this.diShapes.computeIfAbsent(this.getCurrentDiDiagram().getId(), k -> new ArrayList());
        this.diShapes.get(this.getCurrentDiDiagram().getId()).add(diShape);
        this.setCurrentDiShape(diShape);
    }

    public void addDiEdge(DmnDiEdge diEdge) {
        this.diEdges.computeIfAbsent(this.getCurrentDiDiagram().getId(), k -> new ArrayList());
        this.diEdges.get(this.getCurrentDiDiagram().getId()).add(diEdge);
        this.setCurrentDiEdge((DiEdge)diEdge);
    }

    public DmnDiDiagram getCurrentDiDiagram() {
        return this.currentDiDiagram;
    }

    public void setCurrentDiDiagram(DmnDiDiagram currentDiDiagram) {
        this.currentDiDiagram = currentDiDiagram;
    }

    public DmnDiShape getCurrentDiShape() {
        return this.currentDiShape;
    }

    public void setCurrentDiShape(DmnDiShape currentDiShape) {
        this.currentDiShape = currentDiShape;
    }

    public DiEdge getCurrentDiEdge() {
        return this.currentDiEdge;
    }

    public void setCurrentDiEdge(DiEdge currentDiEdge) {
        this.currentDiEdge = currentDiEdge;
    }

    public List<DmnDiDiagram> getDiDiagrams() {
        return this.diDiagrams;
    }

    public List<DmnDiShape> getDiShapes(String diagramId) {
        return this.diShapes.get(diagramId);
    }

    public List<DmnDiEdge> getDiEdges(String diagramId) {
        return this.diEdges.get(diagramId);
    }
}

