/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.apache.ibatis.transaction.jdbc.JdbcTransaction;
import org.flowable.engine.common.impl.transaction.ConnectionHolder;

public class ContextAwareJdbcTransaction
extends JdbcTransaction {
    protected boolean connectionStored;

    public ContextAwareJdbcTransaction(Connection connection) {
        super(connection);
    }

    public ContextAwareJdbcTransaction(DataSource ds, TransactionIsolationLevel desiredLevel, boolean desiredAutoCommit) {
        super(ds, desiredLevel, desiredAutoCommit);
    }

    protected void openConnection() throws SQLException {
        super.openConnection();
        if (!this.connectionStored) {
            ConnectionHolder.setConnection(this.connection);
        }
    }

    public void close() throws SQLException {
        ConnectionHolder.clear();
        super.close();
    }
}

