/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;

public class ListQueryParameterObject {
    public static final String SORTORDER_ASC = "asc";
    public static final String SORTORDER_DESC = "desc";
    protected int firstResult = -1;
    protected int maxResults = -1;
    protected Object parameter;
    protected String orderByColumns;
    protected QueryProperty orderProperty;
    protected String nullHandlingColumn;
    protected Query.NullHandlingOnOrder nullHandlingOnOrder;
    protected ResultType resultType;
    protected String databaseType;

    public ListQueryParameterObject() {
    }

    public ListQueryParameterObject(Object parameter, int firstResult, int maxResults) {
        this.parameter = parameter;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
    }

    protected void addOrder(String column, String sortOrder, Query.NullHandlingOnOrder nullHandlingOnOrder) {
        this.orderByColumns = this.orderByColumns == null ? "" : this.orderByColumns + ", ";
        String defaultOrderByClause = column + " " + sortOrder;
        if (nullHandlingOnOrder != null) {
            if (nullHandlingOnOrder == Query.NullHandlingOnOrder.NULLS_FIRST) {
                if ("h2".equals(this.databaseType) || "hsql".equals(this.databaseType) || "postgres".equals(this.databaseType) || "oracle".equals(this.databaseType)) {
                    this.orderByColumns = this.orderByColumns + defaultOrderByClause + " NULLS FIRST";
                } else if ("mysql".equals(this.databaseType)) {
                    this.orderByColumns = this.orderByColumns + "isnull(" + column + ") desc," + defaultOrderByClause;
                } else if ("db2".equals(this.databaseType) || "mssql".equals(this.databaseType)) {
                    this.nullHandlingColumn = this.nullHandlingColumn == null ? "" : this.nullHandlingColumn + ", ";
                    String columnName = column.replace("RES.", "") + "_order_null";
                    this.nullHandlingColumn = this.nullHandlingColumn + "case when " + column + " is null then 0 else 1 end " + columnName;
                    this.orderByColumns = this.orderByColumns + columnName + "," + defaultOrderByClause;
                } else {
                    this.orderByColumns = this.orderByColumns + defaultOrderByClause;
                }
            } else if (nullHandlingOnOrder == Query.NullHandlingOnOrder.NULLS_LAST) {
                if ("h2".equals(this.databaseType) || "hsql".equals(this.databaseType) || "postgres".equals(this.databaseType) || "oracle".equals(this.databaseType)) {
                    this.orderByColumns = this.orderByColumns + column + " " + sortOrder + " NULLS LAST";
                } else if ("mysql".equals(this.databaseType)) {
                    this.orderByColumns = this.orderByColumns + "isnull(" + column + ") asc," + defaultOrderByClause;
                } else if ("db2".equals(this.databaseType) || "mssql".equals(this.databaseType)) {
                    this.nullHandlingColumn = this.nullHandlingColumn == null ? "" : this.nullHandlingColumn + ", ";
                    String columnName = column.replace("RES.", "") + "_order_null";
                    this.nullHandlingColumn = this.nullHandlingColumn + "case when " + column + " is null then 1 else 0 end " + columnName;
                    this.orderByColumns = this.orderByColumns + columnName + "," + defaultOrderByClause;
                } else {
                    this.orderByColumns = this.orderByColumns + defaultOrderByClause;
                }
            }
        } else {
            this.orderByColumns = this.orderByColumns + defaultOrderByClause;
        }
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getFirstRow() {
        return this.firstResult + 1;
    }

    public int getLastRow() {
        if (this.maxResults == Integer.MAX_VALUE) {
            return this.maxResults;
        }
        return this.firstResult + this.maxResults + 1;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public void setParameter(Object parameter) {
        this.parameter = parameter;
    }

    public String getOrderBy() {
        if (this.firstResult >= 0 && ("db2".equals(this.databaseType) || "mssql".equals(this.databaseType))) {
            return "";
        }
        return "order by " + this.getOrderByColumns();
    }

    public void setOrderByColumns(String orderByColumns) {
        this.orderByColumns = orderByColumns;
    }

    public String getOrderByColumns() {
        if (this.orderByColumns != null) {
            return this.orderByColumns;
        }
        return "RES.ID_ asc";
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getNullHandlingColumn() {
        return this.nullHandlingColumn;
    }

    public void setNullHandlingColumn(String nullHandlingColumn) {
        this.nullHandlingColumn = nullHandlingColumn;
    }

    public static enum ResultType {
        LIST,
        LIST_PAGE,
        SINGLE_RESULT,
        COUNT;

    }
}

