/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.FlowableVersion;
import org.flowable.common.engine.impl.FlowableVersions;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.DbSqlSessionFactory;
import org.flowable.common.engine.impl.db.DbUpgradeStep;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlScriptBasedDbSchemaManager
implements SchemaManager {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractSqlScriptBasedDbSchemaManager.class);
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    protected static final String PROPERTY_TABLE = "ACT_GE_PROPERTY";
    protected static final String SCHEMA_VERSION_PROPERTY = "schema.version";

    protected void dbSchemaUpgradeUntil6120(String component, int currentDatabaseVersionsIndex) {
        FlowableVersion version = FlowableVersions.FLOWABLE_VERSIONS.get(currentDatabaseVersionsIndex);
        String dbVersion = version.getMainVersion();
        LOGGER.info("upgrading flowable {} schema from {} to {}", new Object[]{component, dbVersion, "6.1.2.0"});
        for (int i = currentDatabaseVersionsIndex + 1; i < FlowableVersions.getFlowableVersionIndexForDbVersion("6.1.2.0"); ++i) {
            String nextVersion = FlowableVersions.FLOWABLE_VERSIONS.get(i).getMainVersion();
            if (nextVersion.endsWith("-SNAPSHOT")) {
                nextVersion = nextVersion.substring(0, nextVersion.length() - "-SNAPSHOT".length());
            }
            dbVersion = dbVersion.replace(".", "");
            nextVersion = nextVersion.replace(".", "");
            LOGGER.info("Upgrade needed: {} -> {}. Looking for schema update resource for component '{}'", new Object[]{dbVersion, nextVersion, component});
            String databaseType = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType();
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + dbVersion + ".to." + nextVersion, component, databaseType), true);
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + dbVersion + ".to." + nextVersion, component, "all"), true);
            dbVersion = nextVersion;
        }
    }

    protected void dbSchemaUpgrade(String component, int currentDatabaseVersionsIndex) {
        FlowableVersion version = FlowableVersions.FLOWABLE_VERSIONS.get(currentDatabaseVersionsIndex);
        String dbVersion = version.getMainVersion();
        LOGGER.info("upgrading flowable {} schema from {} to {}", new Object[]{component, dbVersion, "6.4.0.0"});
        for (int i = currentDatabaseVersionsIndex + 1; i < FlowableVersions.FLOWABLE_VERSIONS.size(); ++i) {
            String nextVersion = FlowableVersions.FLOWABLE_VERSIONS.get(i).getMainVersion();
            if (nextVersion.endsWith("-SNAPSHOT")) {
                nextVersion = nextVersion.substring(0, nextVersion.length() - "-SNAPSHOT".length());
            }
            dbVersion = dbVersion.replace(".", "");
            nextVersion = nextVersion.replace(".", "");
            LOGGER.info("Upgrade needed: {} -> {}. Looking for schema update resource for component '{}'", new Object[]{dbVersion, nextVersion, component});
            String databaseType = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType();
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + dbVersion + ".to." + nextVersion, component, databaseType), true);
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + dbVersion + ".to." + nextVersion, component, "all"), true);
            dbVersion = nextVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        DbSqlSessionFactory dbSqlSessionFactory = dbSqlSession.getDbSqlSessionFactory();
        if (!dbSqlSession.getDbSqlSessionFactory().isTablePrefixIsSchema()) {
            tableName = this.prependDatabaseTablePrefix(tableName);
        }
        Connection connection = null;
        connection = dbSqlSession.getSqlSession().getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String catalog = dbSqlSession.getConnectionMetadataDefaultCatalog();
        if (dbSqlSessionFactory.getDatabaseCatalog() != null && dbSqlSessionFactory.getDatabaseCatalog().length() > 0) {
            catalog = dbSqlSessionFactory.getDatabaseCatalog();
        }
        String schema = dbSqlSession.getConnectionMetadataDefaultSchema();
        if (dbSqlSessionFactory.getDatabaseSchema() != null && dbSqlSessionFactory.getDatabaseSchema().length() > 0) {
            schema = dbSqlSessionFactory.getDatabaseSchema();
        } else if (dbSqlSessionFactory.isTablePrefixIsSchema() && StringUtils.isNotEmpty((CharSequence)dbSqlSessionFactory.getDatabaseTablePrefix()) && StringUtils.isNotEmpty((CharSequence)(schema = dbSqlSessionFactory.getDatabaseTablePrefix())) && schema.endsWith(".")) {
            schema = schema.substring(0, schema.length() - 1);
        }
        String databaseType = dbSqlSessionFactory.getDatabaseType();
        if ("postgres".equals(databaseType)) {
            tableName = tableName.toLowerCase();
        }
        if (schema != null && "oracle".equals(databaseType)) {
            schema = schema.toUpperCase();
        }
        if (catalog != null && catalog.length() == 0) {
            catalog = null;
        }
        try {
            tables = databaseMetaData.getTables(catalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (tables != null) {
                        tables.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error closing meta data tables", (Throwable)e);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FlowableException("couldn't check if tables are already present using metadata: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (tables != null) {
                tables.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error closing meta data tables", (Throwable)e);
        }
        return bl;
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix() + tableName;
    }

    public DbSqlSession getDbSqlSession() {
        return Context.getCommandContext().getSession(DbSqlSession.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String propertyName) {
        String tableName = this.getPropertyTable();
        if (!this.isTablePresent(tableName)) {
            return null;
        }
        if (!this.getDbSqlSession().getDbSqlSessionFactory().isTablePrefixIsSchema()) {
            tableName = this.prependDatabaseTablePrefix(tableName);
        }
        Statement statement = null;
        try {
            statement = this.getDbSqlSession().getSqlSession().getConnection().prepareStatement("select VALUE_ from " + tableName + " where NAME_ = ?");
            statement.setString(1, propertyName);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            LOGGER.error("Could not get property from table {}", (Object)tableName, (Object)e);
            String string = null;
            return string;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected String getPropertyTable() {
        return PROPERTY_TABLE;
    }

    public String getResourceForDbOperation(String directory, String operation, String component, String databaseType) {
        return this.getResourcesRootDirectory() + directory + "/flowable." + databaseType + "." + operation + "." + component + ".sql";
    }

    protected abstract String getResourcesRootDirectory();

    public void executeMandatorySchemaResource(String operation, String component) {
        String databaseType = this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType();
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component, databaseType), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) {
                    throw new FlowableException("resource '" + resourceName + "' is not available");
                }
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        LOGGER.info("performing {} on {} with resource {}", new Object[]{operation, component, resourceName});
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        try {
            Connection connection = dbSqlSession.getSqlSession().getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            try {
                if (dbSqlSession.getDbSqlSessionFactory().isMysql()) {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    int majorVersion = databaseMetaData.getDatabaseMajorVersion();
                    int minorVersion = databaseMetaData.getDatabaseMinorVersion();
                    LOGGER.info("Found MySQL: majorVersion={} minorVersion={}", (Object)majorVersion, (Object)minorVersion);
                    if (majorVersion <= 5 && minorVersion < 6) {
                        ddlStatements = this.updateDdlForMySqlVersionLowerThan56(ddlStatements);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.info("Could not get database metadata", (Throwable)e);
            }
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            boolean inOraclePlsqlBlock = false;
            while (line != null) {
                if (line.startsWith("# ")) {
                    LOGGER.debug(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    LOGGER.debug(line.substring(3));
                } else {
                    if (line.startsWith("execute java ")) {
                        String upgradestepClassName = line.substring(13).trim();
                        DbUpgradeStep dbUpgradeStep = null;
                        try {
                            dbUpgradeStep = (DbUpgradeStep)ReflectUtil.instantiate(upgradestepClassName);
                        }
                        catch (FlowableException e) {
                            throw new FlowableException("database update java class '" + upgradestepClassName + "' can't be instantiated: " + e.getMessage(), (Throwable)e);
                        }
                        try {
                            LOGGER.debug("executing upgrade step java class {}", (Object)upgradestepClassName);
                            dbUpgradeStep.execute();
                        }
                        catch (Exception e) {
                            throw new FlowableException("error while executing database update java class '" + upgradestepClassName + "': " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (line.length() > 0) {
                        if (dbSqlSession.getDbSqlSessionFactory().isOracle() && line.startsWith("begin")) {
                            inOraclePlsqlBlock = true;
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        } else if (line.endsWith(";") && !inOraclePlsqlBlock || line.startsWith("/") && inOraclePlsqlBlock) {
                            if (inOraclePlsqlBlock) {
                                inOraclePlsqlBlock = false;
                            } else {
                                sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                            }
                            Statement jdbcStatement = connection.createStatement();
                            try {
                                LOGGER.debug("SQL: {}", (Object)sqlStatement);
                                jdbcStatement.execute(sqlStatement);
                                jdbcStatement.close();
                            }
                            catch (Exception e) {
                                if (exception == null) {
                                    exception = e;
                                    exceptionSqlStatement = sqlStatement;
                                }
                                LOGGER.error("problem during schema {}, statement {}", new Object[]{operation, sqlStatement, e});
                            }
                            finally {
                                sqlStatement = null;
                            }
                        } else {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        }
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            LOGGER.debug("flowable db schema {} for component {} successful", (Object)operation, (Object)component);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't " + operation + " db schema: " + exceptionSqlStatement, (Throwable)e);
        }
    }

    protected String updateDdlForMySqlVersionLowerThan56(String ddlStatements) {
        return ddlStatements.replace("timestamp(3)", "timestamp").replace("datetime(3)", "datetime").replace("TIMESTAMP(3)", "TIMESTAMP").replace("DATETIME(3)", "DATETIME");
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }
}

