/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableWrongDbException;
import org.flowable.common.engine.impl.FlowableVersions;
import org.flowable.common.engine.impl.db.AbstractSqlScriptBasedDbSchemaManager;

public abstract class ServiceSqlScriptBasedDbSchemaManager
extends AbstractSqlScriptBasedDbSchemaManager {
    protected String table;
    protected String schemaComponent;
    protected String schemaComponentHistory;
    protected String schemaVersionProperty;

    public ServiceSqlScriptBasedDbSchemaManager(String table, String schemaComponent, String schemaComponentHistory, String schemaVersionProperty) {
        this.table = table;
        this.schemaComponent = schemaComponent;
        this.schemaComponentHistory = schemaComponentHistory;
        this.schemaVersionProperty = schemaVersionProperty;
    }

    @Override
    public void schemaCreate() {
        if (this.isUpdateNeeded()) {
            String dbVersion = this.getSchemaVersion();
            if (!"6.4.0.0".equals(dbVersion)) {
                throw new FlowableWrongDbException("6.4.0.0", dbVersion);
            }
        } else {
            this.internalDbSchemaCreate();
        }
    }

    protected void internalDbSchemaCreate() {
        this.executeMandatorySchemaResource("create", this.schemaComponent);
        if (this.isHistoryUsed()) {
            this.executeMandatorySchemaResource("create", this.schemaComponentHistory);
        }
    }

    @Override
    public void schemaDrop() {
        this.executeMandatorySchemaResource("drop", this.schemaComponent);
        if (this.isHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", this.schemaComponentHistory);
        }
    }

    @Override
    public String schemaUpdate() {
        String feedback = null;
        if (this.isUpdateNeeded()) {
            boolean isUpgradeNeeded;
            String dbVersion = this.getSchemaVersion();
            String compareWithVersion = null;
            compareWithVersion = dbVersion == null ? "6.1.2.0" : dbVersion;
            int matchingVersionIndex = FlowableVersions.getFlowableVersionIndexForDbVersion(compareWithVersion);
            boolean bl = isUpgradeNeeded = matchingVersionIndex != FlowableVersions.FLOWABLE_VERSIONS.size() - 1;
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade(this.schemaComponent, matchingVersionIndex);
                if (this.isHistoryUsed()) {
                    this.dbSchemaUpgrade(this.schemaComponentHistory, matchingVersionIndex);
                }
            }
            feedback = "upgraded from " + compareWithVersion + " to " + "6.4.0.0";
        } else {
            this.schemaCreate();
        }
        return feedback;
    }

    @Override
    public void schemaCheckVersion() {
        String dbVersion = this.getSchemaVersion();
        if (!"6.4.0.0".equals(dbVersion)) {
            throw new FlowableWrongDbException("6.4.0.0", dbVersion);
        }
    }

    protected boolean isUpdateNeeded() {
        return this.isTablePresent(this.table);
    }

    protected boolean isHistoryUsed() {
        return this.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed() && this.schemaComponentHistory != null;
    }

    protected String getSchemaVersion() {
        if (this.schemaVersionProperty == null) {
            throw new FlowableException("Schema version property is not set");
        }
        String dbVersion = this.getProperty(this.schemaVersionProperty);
        if (dbVersion == null) {
            return this.getUpgradeStartVersion();
        }
        return dbVersion;
    }

    protected String getUpgradeStartVersion() {
        return "6.1.2.0";
    }
}

