/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.async;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.flowable.common.engine.api.async.AsyncTaskExecutor;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncTaskExecutor
implements AsyncTaskExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ExecutorService executorService;
    protected boolean executorNeedsShutdown;
    protected int corePoolSize = 8;
    protected int maxPoolSize = 8;
    protected long keepAliveTime = 5000L;
    protected int queueSize = 100;
    protected boolean allowCoreThreadTimeout = true;
    protected long secondsToWaitOnShutdown = 60L;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected String threadPoolNamingPattern = "flowable-async-job-executor-thread-%d";
    protected ThreadFactory threadFactory;
    protected RejectedExecutionHandler rejectedExecutionHandler;

    public void execute(Runnable task) {
        this.executorService.execute(task);
    }

    public CompletableFuture<?> submit(Runnable task) {
        return CompletableFuture.runAsync(task, this.executorService);
    }

    public <T> CompletableFuture<T> submit(Callable<T> task) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return task.call();
            }
            catch (Exception exception) {
                ExceptionUtil.sneakyThrow(exception);
                return null;
            }
        }, this.executorService);
    }

    public void start() {
        if (this.executorService == null) {
            this.executorService = this.initializeExecutor();
            this.executorNeedsShutdown = true;
        }
    }

    public void shutdown() {
        if (this.executorService != null && this.executorNeedsShutdown) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(this.secondsToWaitOnShutdown, TimeUnit.SECONDS)) {
                    this.logger.warn("Timeout during shutdown of async job executor. The current running jobs could not end within {} seconds after shutdown operation.", (Object)this.secondsToWaitOnShutdown);
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while shutting down the async job executor. ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.executorService = null;
        }
    }

    protected ExecutorService initializeExecutor() {
        if (this.threadPoolQueue == null) {
            this.logger.info("Creating thread pool queue of size {}", (Object)this.queueSize);
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.threadFactory == null) {
            this.logger.info("Creating thread factory with naming pattern {}", (Object)this.threadPoolNamingPattern);
            this.threadFactory = new BasicThreadFactory.Builder().namingPattern(this.threadPoolNamingPattern).build();
        }
        this.logger.info("Creating executor service with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{this.corePoolSize, this.maxPoolSize, this.keepAliveTime});
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, this.threadPoolQueue, this.threadFactory);
        threadPoolExecutor.allowCoreThreadTimeOut(this.allowCoreThreadTimeout);
        if (this.rejectedExecutionHandler != null) {
            this.logger.info("Using rejectedExecutionHandler {}", (Object)this.rejectedExecutionHandler);
            threadPoolExecutor.setRejectedExecutionHandler(this.rejectedExecutionHandler);
        }
        return threadPoolExecutor;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public boolean isAllowCoreThreadTimeout() {
        return this.allowCoreThreadTimeout;
    }

    public void setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
        this.allowCoreThreadTimeout = allowCoreThreadTimeout;
    }

    public long getSecondsToWaitOnShutdown() {
        return this.secondsToWaitOnShutdown;
    }

    public void setSecondsToWaitOnShutdown(long secondsToWaitOnShutdown) {
        this.secondsToWaitOnShutdown = secondsToWaitOnShutdown;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public String getThreadPoolNamingPattern() {
        return this.threadPoolNamingPattern;
    }

    public void setThreadPoolNamingPattern(String threadPoolNamingPattern) {
        this.threadPoolNamingPattern = threadPoolNamingPattern;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }
}

