/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableWrongDbException;
import org.flowable.common.engine.api.lock.LockManager;
import org.flowable.common.engine.impl.FlowableVersions;
import org.flowable.common.engine.impl.db.AbstractSqlScriptBasedDbSchemaManager;
import org.flowable.common.engine.impl.db.SchemaManagerDatabaseConfiguration;
import org.flowable.common.engine.impl.db.SchemaManagerLockConfiguration;

public abstract class EngineSqlScriptBasedDbSchemaManager
extends AbstractSqlScriptBasedDbSchemaManager {
    protected final String context;
    protected final SchemaManagerLockConfiguration lockConfiguration;

    protected EngineSqlScriptBasedDbSchemaManager(String context, SchemaManagerLockConfiguration lockConfiguration) {
        this.context = context;
        this.lockConfiguration = lockConfiguration;
    }

    protected abstract String getEngineVersion();

    protected abstract String getSchemaVersionPropertyName();

    protected abstract String getDbSchemaLockName();

    protected abstract String getEngineTableName();

    protected abstract String getChangeLogTableName();

    protected abstract String getDbVersionForChangelogVersion(String var1);

    @Override
    public void schemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            String currentVersion = this.getEngineVersion();
            if (!currentVersion.equals(dbVersion)) {
                throw new FlowableWrongDbException(currentVersion, dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, this.context);
            }
            if (errorMessage != null) {
                throw new FlowableException("Flowable database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new FlowableException("No flowable tables in DB. Set property \"databaseSchemaUpdate\" \"true\" or value=\"create-drop\" (use create-drop for testing only!) for automatic schema creation", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlowableException("couldn't get " + this.context + " db schema version", (Throwable)e);
        }
        this.logger.debug("flowable {} db schema check successful", (Object)this.context);
    }

    @Override
    public void schemaCreate() {
        if (this.lockConfiguration.isUseLockForDatabaseSchemaUpdate()) {
            LockManager lockManager = this.lockConfiguration.getLockManager(this.getDbSchemaLockName());
            lockManager.waitForLockRunAndRelease(this.lockConfiguration.getSchemaLockWaitTime(), () -> {
                this.schemaCreateInLock();
                return null;
            });
        } else {
            this.schemaCreateInLock();
        }
    }

    protected void schemaCreateInLock() {
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            String engineVersion = this.getEngineVersion();
            if (!engineVersion.equals(dbVersion)) {
                throw new FlowableWrongDbException(engineVersion, dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", this.context);
    }

    @Override
    public void schemaDrop() {
        try {
            this.executeMandatorySchemaResource("drop", this.context);
        }
        catch (Exception e) {
            this.logger.info("Error dropping {} tables", (Object)this.context, (Object)e);
        }
    }

    @Override
    public String schemaUpdate() {
        if (this.lockConfiguration.isUseLockForDatabaseSchemaUpdate()) {
            LockManager lockManager = this.lockConfiguration.getLockManager(this.getDbSchemaLockName());
            return (String)lockManager.waitForLockRunAndRelease(this.lockConfiguration.getSchemaLockWaitTime(), this::schemaUpdateInLock);
        }
        return this.schemaUpdateInLock();
    }

    protected String schemaUpdateInLock() {
        String feedback = null;
        boolean isUpgradeNeeded = false;
        int matchingVersionIndex = -1;
        boolean isEngineTablePresent = this.isEngineTablePresent();
        String dbVersion = null;
        if (isEngineTablePresent && (dbVersion = this.getDbVersion()) == null) {
            dbVersion = this.getChangeLogVersion().dbVersion();
        }
        if (isEngineTablePresent) {
            matchingVersionIndex = FlowableVersions.getFlowableVersionIndexForDbVersion(dbVersion);
            boolean bl = isUpgradeNeeded = matchingVersionIndex != FlowableVersions.FLOWABLE_VERSIONS.size() - 1;
        }
        if (isUpgradeNeeded) {
            this.dbSchemaUpgrade(this.context, matchingVersionIndex, dbVersion);
            feedback = "upgraded Flowable from " + dbVersion + " to " + this.getEngineVersion();
        } else if (!isEngineTablePresent) {
            this.dbSchemaCreateEngine();
        }
        return feedback;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent(this.getEngineTableName());
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        return this.getProperty(this.getSchemaVersionPropertyName(), false);
    }

    protected int getChangeLogVersionOrder(String changeLogVersion) {
        return Integer.parseInt(changeLogVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ChangeLogVersion getChangeLogVersion() {
        String changeLogTableName = this.getChangeLogTableName();
        if (changeLogTableName == null) return new ChangeLogVersion(null, this.getDbVersionForChangelogVersion(null));
        if (!this.isTablePresent(changeLogTableName)) return new ChangeLogVersion(null, this.getDbVersionForChangelogVersion(null));
        SchemaManagerDatabaseConfiguration databaseConfiguration = this.getDatabaseConfiguration();
        if (!databaseConfiguration.isTablePrefixIsSchema()) {
            changeLogTableName = this.prependDatabaseTablePrefix(changeLogTableName);
        }
        try (PreparedStatement statement = databaseConfiguration.getConnection().prepareStatement("select ID from " + changeLogTableName + " order by DATEEXECUTED");){
            int latestChangeLogVersionOrder = 0;
            String changeLogVersion2 = null;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String changeLogVersionId = resultSet.getString(1);
                    int changeLogVersionOrder = this.getChangeLogVersionOrder(changeLogVersionId);
                    if (changeLogVersionOrder <= latestChangeLogVersionOrder) continue;
                    changeLogVersion2 = changeLogVersionId;
                    latestChangeLogVersionOrder = changeLogVersionOrder;
                }
            }
            if (changeLogVersion2 == null) return new ChangeLogVersion(null, this.getDbVersionForChangelogVersion(null));
            ChangeLogVersion changeLogVersion = new ChangeLogVersion(changeLogVersion2, this.getDbVersionForChangelogVersion(changeLogVersion2));
            return changeLogVersion;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to get change log version from " + changeLogTableName, e);
        }
    }

    public record ChangeLogVersion(String version, String dbVersion) {
    }
}

