/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.SqlSessionFactory;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.Session;
import org.flowable.common.engine.impl.interceptor.SessionFactory;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.common.engine.impl.persistence.entity.Entity;

public class DbSqlSessionFactory
implements SessionFactory {
    protected Map<String, Map<String, String>> databaseSpecificStatements = new HashMap<String, Map<String, String>>();
    protected String databaseType;
    protected String databaseTablePrefix = "";
    protected boolean tablePrefixIsSchema;
    protected String databaseCatalog;
    protected String databaseSchema;
    protected SqlSessionFactory sqlSessionFactory;
    protected Map<String, String> statementMappings;
    protected Map<Class<?>, String> insertStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> updateStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> deleteStatements = new ConcurrentHashMap();
    protected Map<Class<?>, String> selectStatements = new ConcurrentHashMap();
    protected List<Class<? extends Entity>> insertionOrder = new ArrayList<Class<? extends Entity>>();
    protected List<Class<? extends Entity>> deletionOrder = new ArrayList<Class<? extends Entity>>();
    protected Collection<Class<? extends Entity>> immutableEntities = new HashSet<Class<? extends Entity>>();
    protected boolean isDbHistoryUsed = true;
    protected Set<Class<? extends Entity>> bulkInserteableEntityClasses = new HashSet<Class<? extends Entity>>();
    protected Map<Class<?>, String> bulkInsertStatements = new ConcurrentHashMap();
    protected int maxNrOfStatementsInBulkInsert = 100;
    protected Map<String, Class<?>> logicalNameToClassMapping = new ConcurrentHashMap();
    protected boolean usePrefixId;

    public DbSqlSessionFactory(boolean usePrefixId) {
        this.usePrefixId = usePrefixId;
    }

    @Override
    public Class<?> getSessionType() {
        return DbSqlSession.class;
    }

    @Override
    public Session openSession(CommandContext commandContext) {
        DbSqlSession dbSqlSession = this.createDbSqlSession();
        if (this.getDatabaseSchema() != null && this.getDatabaseSchema().length() > 0) {
            try {
                dbSqlSession.getSqlSession().getConnection().setSchema(this.getDatabaseSchema());
            }
            catch (SQLException e) {
                throw new FlowableException("Could not set database schema on connection", (Throwable)e);
            }
        }
        if (this.getDatabaseCatalog() != null && this.getDatabaseCatalog().length() > 0) {
            try {
                dbSqlSession.getSqlSession().getConnection().setCatalog(this.getDatabaseCatalog());
            }
            catch (SQLException e) {
                throw new FlowableException("Could not set database catalog on connection", (Throwable)e);
            }
        }
        if (dbSqlSession.getSqlSession().getConnection() == null) {
            throw new FlowableException("Invalid dbSqlSession: no active connection found");
        }
        return dbSqlSession;
    }

    protected DbSqlSession createDbSqlSession() {
        return new DbSqlSession(this, Context.getCommandContext().getSession(EntityCache.class));
    }

    public String getInsertStatement(Entity object) {
        return this.getStatement(object.getClass(), this.insertStatements, "insert");
    }

    public String getInsertStatement(Class<? extends Entity> clazz) {
        return this.getStatement(clazz, this.insertStatements, "insert");
    }

    public String getUpdateStatement(Entity object) {
        return this.getStatement(object.getClass(), this.updateStatements, "update");
    }

    public String getDeleteStatement(Class<?> entityClass) {
        return this.getStatement(entityClass, this.deleteStatements, "delete");
    }

    public String getSelectStatement(Class<?> entityClass) {
        return this.getStatement(entityClass, this.selectStatements, "select");
    }

    protected String getStatement(Class<?> entityClass, Map<Class<?>, String> cachedStatements, String prefix) {
        Object statement = cachedStatements.get(entityClass);
        if (statement != null) {
            return statement;
        }
        statement = prefix + entityClass.getSimpleName();
        statement = ((String)statement).endsWith("Impl") ? ((String)statement).substring(0, ((String)statement).length() - 10) : ((String)statement).substring(0, ((String)statement).length() - 6);
        cachedStatements.put(entityClass, (String)statement);
        return statement;
    }

    protected void addDatabaseSpecificStatement(String databaseType, String activitiStatement, String ibatisStatement) {
        Map<String, String> specificStatements = this.databaseSpecificStatements.get(databaseType);
        if (specificStatements == null) {
            specificStatements = new HashMap<String, String>();
            this.databaseSpecificStatements.put(databaseType, specificStatements);
        }
        specificStatements.put(activitiStatement, ibatisStatement);
    }

    public String mapStatement(String statement) {
        if (this.statementMappings == null) {
            return statement;
        }
        String mappedStatement = this.statementMappings.get(statement);
        return mappedStatement != null ? mappedStatement : statement;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
        this.statementMappings = this.databaseSpecificStatements.get(databaseType);
    }

    public boolean isMysql() {
        return "mysql".equals(this.getDatabaseType());
    }

    public boolean isOracle() {
        return "oracle".equals(this.getDatabaseType());
    }

    public Boolean isBulkInsertable(Class<? extends Entity> entityClass) {
        return this.bulkInserteableEntityClasses != null && this.bulkInserteableEntityClasses.contains(entityClass);
    }

    public String getBulkInsertStatement(Class clazz) {
        return this.getStatement(clazz, this.bulkInsertStatements, "bulkInsert");
    }

    public Set<Class<? extends Entity>> getBulkInserteableEntityClasses() {
        return this.bulkInserteableEntityClasses;
    }

    public void setBulkInserteableEntityClasses(Set<Class<? extends Entity>> bulkInserteableEntityClasses) {
        this.bulkInserteableEntityClasses = bulkInserteableEntityClasses;
    }

    public int getMaxNrOfStatementsInBulkInsert() {
        return this.maxNrOfStatementsInBulkInsert;
    }

    public void setMaxNrOfStatementsInBulkInsert(int maxNrOfStatementsInBulkInsert) {
        this.maxNrOfStatementsInBulkInsert = maxNrOfStatementsInBulkInsert;
    }

    public Map<Class<?>, String> getBulkInsertStatements() {
        return this.bulkInsertStatements;
    }

    public void setBulkInsertStatements(Map<Class<?>, String> bulkInsertStatements) {
        this.bulkInsertStatements = bulkInsertStatements;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public Map<String, Map<String, String>> getDatabaseSpecificStatements() {
        return this.databaseSpecificStatements;
    }

    public void setDatabaseSpecificStatements(Map<String, Map<String, String>> databaseSpecificStatements) {
        this.databaseSpecificStatements = databaseSpecificStatements;
    }

    public Map<String, String> getStatementMappings() {
        return this.statementMappings;
    }

    public void setStatementMappings(Map<String, String> statementMappings) {
        this.statementMappings = statementMappings;
    }

    public Map<Class<?>, String> getInsertStatements() {
        return this.insertStatements;
    }

    public void setInsertStatements(Map<Class<?>, String> insertStatements) {
        this.insertStatements = insertStatements;
    }

    public Map<Class<?>, String> getUpdateStatements() {
        return this.updateStatements;
    }

    public void setUpdateStatements(Map<Class<?>, String> updateStatements) {
        this.updateStatements = updateStatements;
    }

    public Map<Class<?>, String> getDeleteStatements() {
        return this.deleteStatements;
    }

    public void setDeleteStatements(Map<Class<?>, String> deleteStatements) {
        this.deleteStatements = deleteStatements;
    }

    public Map<Class<?>, String> getSelectStatements() {
        return this.selectStatements;
    }

    public void setSelectStatements(Map<Class<?>, String> selectStatements) {
        this.selectStatements = selectStatements;
    }

    public boolean isDbHistoryUsed() {
        return this.isDbHistoryUsed;
    }

    public void setDbHistoryUsed(boolean isDbHistoryUsed) {
        this.isDbHistoryUsed = isDbHistoryUsed;
    }

    public void setDatabaseTablePrefix(String databaseTablePrefix) {
        this.databaseTablePrefix = databaseTablePrefix;
    }

    public String getDatabaseTablePrefix() {
        return this.databaseTablePrefix;
    }

    public String getDatabaseCatalog() {
        return this.databaseCatalog;
    }

    public void setDatabaseCatalog(String databaseCatalog) {
        this.databaseCatalog = databaseCatalog;
    }

    public String getDatabaseSchema() {
        return this.databaseSchema;
    }

    public void setDatabaseSchema(String databaseSchema) {
        this.databaseSchema = databaseSchema;
    }

    public void setTablePrefixIsSchema(boolean tablePrefixIsSchema) {
        this.tablePrefixIsSchema = tablePrefixIsSchema;
    }

    public boolean isTablePrefixIsSchema() {
        return this.tablePrefixIsSchema;
    }

    public List<Class<? extends Entity>> getInsertionOrder() {
        return this.insertionOrder;
    }

    public void setInsertionOrder(List<Class<? extends Entity>> insertionOrder) {
        this.insertionOrder = insertionOrder;
    }

    public List<Class<? extends Entity>> getDeletionOrder() {
        return this.deletionOrder;
    }

    public void setDeletionOrder(List<Class<? extends Entity>> deletionOrder) {
        this.deletionOrder = deletionOrder;
    }

    public Collection<Class<? extends Entity>> getImmutableEntities() {
        return this.immutableEntities;
    }

    public void setImmutableEntities(Collection<Class<? extends Entity>> immutableEntities) {
        this.immutableEntities = immutableEntities;
    }

    public void addLogicalEntityClassMapping(String logicalName, Class<?> entityClass) {
        this.logicalNameToClassMapping.put(logicalName, entityClass);
    }

    public Map<String, Class<?>> getLogicalNameToClassMapping() {
        return this.logicalNameToClassMapping;
    }

    public void setLogicalNameToClassMapping(Map<String, Class<?>> logicalNameToClassMapping) {
        this.logicalNameToClassMapping = logicalNameToClassMapping;
    }

    public boolean isUsePrefixId() {
        return this.usePrefixId;
    }

    public void setUsePrefixId(boolean usePrefixId) {
        this.usePrefixId = usePrefixId;
    }
}

