/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor.multitenant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.asyncexecutor.AbstractAsyncJobExecutor;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareAcquireAsyncJobsDueRunnable;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareAcquireTimerJobsRunnable;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareAsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareAsyncExecutorFactory;
import org.activiti.engine.impl.asyncexecutor.multitenant.TenantAwareExecuteAsyncRunnableFactory;
import org.activiti.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorPerTenantAsyncExecutor
implements TenantAwareAsyncExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorPerTenantAsyncExecutor.class);
    protected TenantInfoHolder tenantInfoHolder;
    protected TenantAwareAsyncExecutorFactory tenantAwareAyncExecutorFactory;
    protected Map<String, AsyncExecutor> tenantExecutors = new HashMap<String, AsyncExecutor>();
    protected CommandExecutor commandExecutor;
    protected boolean active;
    protected boolean autoActivate;

    public ExecutorPerTenantAsyncExecutor(TenantInfoHolder tenantInfoHolder) {
        this(tenantInfoHolder, null);
    }

    public ExecutorPerTenantAsyncExecutor(TenantInfoHolder tenantInfoHolder, TenantAwareAsyncExecutorFactory tenantAwareAyncExecutorFactory) {
        this.tenantInfoHolder = tenantInfoHolder;
        this.tenantAwareAyncExecutorFactory = tenantAwareAyncExecutorFactory;
    }

    @Override
    public Set<String> getTenantIds() {
        return this.tenantExecutors.keySet();
    }

    @Override
    public void addTenantAsyncExecutor(String tenantId, boolean startExecutor) {
        AsyncExecutor tenantExecutor = null;
        tenantExecutor = this.tenantAwareAyncExecutorFactory == null ? new DefaultAsyncJobExecutor() : this.tenantAwareAyncExecutorFactory.createAsyncExecutor(tenantId);
        if (tenantExecutor instanceof AbstractAsyncJobExecutor) {
            AbstractAsyncJobExecutor defaultAsyncJobExecutor = (AbstractAsyncJobExecutor)tenantExecutor;
            defaultAsyncJobExecutor.setAsyncJobsDueRunnable(new TenantAwareAcquireAsyncJobsDueRunnable(defaultAsyncJobExecutor, this.tenantInfoHolder, tenantId));
            defaultAsyncJobExecutor.setTimerJobRunnable(new TenantAwareAcquireTimerJobsRunnable(defaultAsyncJobExecutor, this.tenantInfoHolder, tenantId));
            defaultAsyncJobExecutor.setExecuteAsyncRunnableFactory(new TenantAwareExecuteAsyncRunnableFactory(this.tenantInfoHolder, tenantId));
        }
        tenantExecutor.setCommandExecutor(this.commandExecutor);
        this.tenantExecutors.put(tenantId, tenantExecutor);
        if (startExecutor) {
            this.startTenantExecutor(tenantId);
        }
    }

    @Override
    public void removeTenantAsyncExecutor(String tenantId) {
        this.shutdownTenantExecutor(tenantId);
        this.tenantExecutors.remove(tenantId);
    }

    protected AsyncExecutor determineAsyncExecutor() {
        return this.tenantExecutors.get(this.tenantInfoHolder.getCurrentTenantId());
    }

    @Override
    public boolean executeAsyncJob(JobEntity job) {
        return this.determineAsyncExecutor().executeAsyncJob(job);
    }

    @Override
    public int getRemainingCapacity() {
        return this.determineAsyncExecutor().getRemainingCapacity();
    }

    @Override
    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setCommandExecutor(commandExecutor);
        }
    }

    @Override
    public CommandExecutor getCommandExecutor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAutoActivate() {
        return this.autoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.autoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void start() {
        for (String tenantId : this.tenantExecutors.keySet()) {
            this.startTenantExecutor(tenantId);
        }
        this.active = true;
    }

    private void startTenantExecutor(String tenantId) {
        this.tenantInfoHolder.setCurrentTenantId(tenantId);
        this.tenantExecutors.get(tenantId).start();
        this.tenantInfoHolder.clearCurrentTenantId();
    }

    @Override
    public synchronized void shutdown() {
        for (String tenantId : this.tenantExecutors.keySet()) {
            this.shutdownTenantExecutor(tenantId);
        }
        this.active = false;
    }

    protected void shutdownTenantExecutor(String tenantId) {
        logger.info("Shutting down async executor for tenant " + tenantId);
        this.tenantExecutors.get(tenantId).shutdown();
    }

    @Override
    public String getLockOwner() {
        return this.determineAsyncExecutor().getLockOwner();
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return this.determineAsyncExecutor().getTimerLockTimeInMillis();
    }

    @Override
    public void setTimerLockTimeInMillis(int lockTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setTimerLockTimeInMillis(lockTimeInMillis);
        }
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return this.determineAsyncExecutor().getAsyncJobLockTimeInMillis();
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int lockTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setAsyncJobLockTimeInMillis(lockTimeInMillis);
        }
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultTimerJobAcquireWaitTimeInMillis();
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int waitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultTimerJobAcquireWaitTimeInMillis(waitTimeInMillis);
        }
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultAsyncJobAcquireWaitTimeInMillis();
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int waitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultAsyncJobAcquireWaitTimeInMillis(waitTimeInMillis);
        }
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultQueueSizeFullWaitTimeInMillis();
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTime) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultQueueSizeFullWaitTimeInMillis(defaultQueueSizeFullWaitTime);
        }
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.determineAsyncExecutor().getMaxAsyncJobsDuePerAcquisition();
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxJobs) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setMaxAsyncJobsDuePerAcquisition(maxJobs);
        }
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.determineAsyncExecutor().getMaxTimerJobsPerAcquisition();
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxJobs) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setMaxTimerJobsPerAcquisition(maxJobs);
        }
    }

    @Override
    public int getRetryWaitTimeInMillis() {
        return this.determineAsyncExecutor().getRetryWaitTimeInMillis();
    }

    @Override
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setRetryWaitTimeInMillis(retryWaitTimeInMillis);
        }
    }
}

