/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.delegate.event.impl;

import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.common.api.delegate.event.FlowableEntityEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.api.delegate.event.FlowableEventListener;
import org.flowable.engine.common.api.delegate.event.FlowableEventType;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventSupport;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.event.FlowableEngineEvent;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class FlowableEventDispatcherImpl
implements FlowableEventDispatcher {
    protected FlowableEventSupport eventSupport = new FlowableEventSupport();
    protected boolean enabled = true;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addEventListener(FlowableEventListener listenerToAdd) {
        this.eventSupport.addEventListener(listenerToAdd);
    }

    public void addEventListener(FlowableEventListener listenerToAdd, FlowableEventType ... types) {
        this.eventSupport.addEventListener(listenerToAdd, types);
    }

    public void removeEventListener(FlowableEventListener listenerToRemove) {
        this.eventSupport.removeEventListener(listenerToRemove);
    }

    public void dispatchEvent(FlowableEvent event) {
        BpmnModel bpmnModel;
        FlowableEntityEvent entityEvent;
        if (this.enabled) {
            this.eventSupport.dispatchEvent(event);
        }
        if (event.getType() == FlowableEngineEventType.ENTITY_DELETED && event instanceof FlowableEntityEvent && (entityEvent = (FlowableEntityEvent)event).getEntity() instanceof ProcessDefinition) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null && (bpmnModel = this.extractBpmnModelFromEvent(event)) != null) {
            ((FlowableEventSupport)bpmnModel.getEventSupport()).dispatchEvent(event);
        }
    }

    protected BpmnModel extractBpmnModelFromEvent(FlowableEvent event) {
        ProcessDefinition processDefinition;
        BpmnModel result = null;
        if (result == null && event instanceof FlowableEngineEvent && ((FlowableEngineEvent)event).getProcessDefinitionId() != null && (processDefinition = ProcessDefinitionUtil.getProcessDefinition(((FlowableEngineEvent)event).getProcessDefinitionId(), true)) != null) {
            result = Context.getProcessEngineConfiguration().getDeploymentManager().resolveProcessDefinition(processDefinition).getBpmnModel();
        }
        return result;
    }
}

