/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor.multitenant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.flowable.engine.impl.asyncexecutor.AbstractAsyncExecutor;
import org.flowable.engine.impl.asyncexecutor.AsyncExecutor;
import org.flowable.engine.impl.asyncexecutor.DefaultAsyncJobExecutor;
import org.flowable.engine.impl.asyncexecutor.JobManager;
import org.flowable.engine.impl.asyncexecutor.multitenant.TenantAwareAcquireAsyncJobsDueRunnable;
import org.flowable.engine.impl.asyncexecutor.multitenant.TenantAwareAcquireTimerJobsRunnable;
import org.flowable.engine.impl.asyncexecutor.multitenant.TenantAwareAsyncExecutor;
import org.flowable.engine.impl.asyncexecutor.multitenant.TenantAwareAsyncExecutorFactory;
import org.flowable.engine.impl.asyncexecutor.multitenant.TenantAwareExecuteAsyncRunnableFactory;
import org.flowable.engine.impl.asyncexecutor.multitenant.TenantAwareResetExpiredJobsRunnable;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cfg.multitenant.TenantInfoHolder;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorPerTenantAsyncExecutor
implements TenantAwareAsyncExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorPerTenantAsyncExecutor.class);
    protected TenantInfoHolder tenantInfoHolder;
    protected TenantAwareAsyncExecutorFactory tenantAwareAyncExecutorFactory;
    protected Map<String, AsyncExecutor> tenantExecutors = new HashMap<String, AsyncExecutor>();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected boolean active;
    protected boolean autoActivate;

    public ExecutorPerTenantAsyncExecutor(TenantInfoHolder tenantInfoHolder) {
        this(tenantInfoHolder, null);
    }

    public ExecutorPerTenantAsyncExecutor(TenantInfoHolder tenantInfoHolder, TenantAwareAsyncExecutorFactory tenantAwareAyncExecutorFactory) {
        this.tenantInfoHolder = tenantInfoHolder;
        this.tenantAwareAyncExecutorFactory = tenantAwareAyncExecutorFactory;
    }

    @Override
    public Set<String> getTenantIds() {
        return this.tenantExecutors.keySet();
    }

    @Override
    public void addTenantAsyncExecutor(String tenantId, boolean startExecutor) {
        AsyncExecutor tenantExecutor = null;
        tenantExecutor = this.tenantAwareAyncExecutorFactory == null ? new DefaultAsyncJobExecutor() : this.tenantAwareAyncExecutorFactory.createAsyncExecutor(tenantId);
        tenantExecutor.setProcessEngineConfiguration(this.processEngineConfiguration);
        if (tenantExecutor instanceof AbstractAsyncExecutor) {
            AbstractAsyncExecutor defaultAsyncJobExecutor = (AbstractAsyncExecutor)tenantExecutor;
            defaultAsyncJobExecutor.setAsyncJobsDueRunnable(new TenantAwareAcquireAsyncJobsDueRunnable(defaultAsyncJobExecutor, this.tenantInfoHolder, tenantId));
            defaultAsyncJobExecutor.setTimerJobRunnable(new TenantAwareAcquireTimerJobsRunnable(defaultAsyncJobExecutor, this.tenantInfoHolder, tenantId));
            defaultAsyncJobExecutor.setExecuteAsyncRunnableFactory(new TenantAwareExecuteAsyncRunnableFactory(this.tenantInfoHolder, tenantId));
            defaultAsyncJobExecutor.setResetExpiredJobsRunnable(new TenantAwareResetExpiredJobsRunnable(defaultAsyncJobExecutor, this.tenantInfoHolder, tenantId));
        }
        this.tenantExecutors.put(tenantId, tenantExecutor);
        if (startExecutor) {
            this.startTenantExecutor(tenantId);
        }
    }

    @Override
    public void removeTenantAsyncExecutor(String tenantId) {
        this.shutdownTenantExecutor(tenantId);
        this.tenantExecutors.remove(tenantId);
    }

    protected AsyncExecutor determineAsyncExecutor() {
        return this.tenantExecutors.get(this.tenantInfoHolder.getCurrentTenantId());
    }

    @Override
    public boolean executeAsyncJob(Job job) {
        return this.determineAsyncExecutor().executeAsyncJob(job);
    }

    @Override
    public int getRemainingCapacity() {
        return this.determineAsyncExecutor().getRemainingCapacity();
    }

    public JobManager getJobManager() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setProcessEngineConfiguration(processEngineConfiguration);
        }
    }

    @Override
    public ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAutoActivate() {
        return this.autoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.autoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void start() {
        for (String tenantId : this.tenantExecutors.keySet()) {
            this.startTenantExecutor(tenantId);
        }
        this.active = true;
    }

    protected void startTenantExecutor(String tenantId) {
        this.tenantInfoHolder.setCurrentTenantId(tenantId);
        this.tenantExecutors.get(tenantId).start();
        this.tenantInfoHolder.clearCurrentTenantId();
    }

    @Override
    public synchronized void shutdown() {
        for (String tenantId : this.tenantExecutors.keySet()) {
            this.shutdownTenantExecutor(tenantId);
        }
        this.active = false;
    }

    protected void shutdownTenantExecutor(String tenantId) {
        logger.info("Shutting down async executor for tenant {}", (Object)tenantId);
        this.tenantExecutors.get(tenantId).shutdown();
    }

    @Override
    public String getLockOwner() {
        return this.determineAsyncExecutor().getLockOwner();
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return this.determineAsyncExecutor().getTimerLockTimeInMillis();
    }

    @Override
    public void setTimerLockTimeInMillis(int lockTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setTimerLockTimeInMillis(lockTimeInMillis);
        }
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return this.determineAsyncExecutor().getAsyncJobLockTimeInMillis();
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int lockTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setAsyncJobLockTimeInMillis(lockTimeInMillis);
        }
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultTimerJobAcquireWaitTimeInMillis();
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int waitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultTimerJobAcquireWaitTimeInMillis(waitTimeInMillis);
        }
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultAsyncJobAcquireWaitTimeInMillis();
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int waitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultAsyncJobAcquireWaitTimeInMillis(waitTimeInMillis);
        }
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return this.determineAsyncExecutor().getDefaultQueueSizeFullWaitTimeInMillis();
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setDefaultQueueSizeFullWaitTimeInMillis(defaultQueueSizeFullWaitTimeInMillis);
        }
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.determineAsyncExecutor().getMaxAsyncJobsDuePerAcquisition();
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxJobs) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setMaxAsyncJobsDuePerAcquisition(maxJobs);
        }
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.determineAsyncExecutor().getMaxTimerJobsPerAcquisition();
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxJobs) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setMaxTimerJobsPerAcquisition(maxJobs);
        }
    }

    @Override
    public int getRetryWaitTimeInMillis() {
        return this.determineAsyncExecutor().getRetryWaitTimeInMillis();
    }

    @Override
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setRetryWaitTimeInMillis(retryWaitTimeInMillis);
        }
    }

    @Override
    public int getResetExpiredJobsInterval() {
        return this.determineAsyncExecutor().getResetExpiredJobsInterval();
    }

    @Override
    public void setResetExpiredJobsInterval(int resetExpiredJobsInterval) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setResetExpiredJobsInterval(resetExpiredJobsInterval);
        }
    }

    @Override
    public int getResetExpiredJobsPageSize() {
        return this.determineAsyncExecutor().getResetExpiredJobsPageSize();
    }

    @Override
    public void setResetExpiredJobsPageSize(int resetExpiredJobsPageSize) {
        for (AsyncExecutor asyncExecutor : this.tenantExecutors.values()) {
            asyncExecutor.setResetExpiredJobsPageSize(resetExpiredJobsPageSize);
        }
    }
}

