/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.naming.NamingException;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.flowable.engine.cfg.MailServerInfo;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MailActivityBehavior.class);
    private static final Class<?>[] ALLOWED_ATT_TYPES = new Class[]{File.class, File[].class, String.class, String[].class, DataSource.class, DataSource[].class};
    protected Expression to;
    protected Expression from;
    protected Expression cc;
    protected Expression bcc;
    protected Expression subject;
    protected Expression text;
    protected Expression textVar;
    protected Expression html;
    protected Expression htmlVar;
    protected Expression charset;
    protected Expression ignoreException;
    protected Expression exceptionVariableName;
    protected Expression attachments;

    @Override
    public void execute(DelegateExecution execution) {
        boolean doIgnoreException = Boolean.parseBoolean(this.getStringFromField(this.ignoreException, execution));
        String exceptionVariable = this.getStringFromField(this.exceptionVariableName, execution);
        Email email = null;
        try {
            String toStr = this.getStringFromField(this.to, execution);
            String fromStr = this.getStringFromField(this.from, execution);
            String ccStr = this.getStringFromField(this.cc, execution);
            String bccStr = this.getStringFromField(this.bcc, execution);
            String subjectStr = this.getStringFromField(this.subject, execution);
            String textStr = this.textVar == null ? this.getStringFromField(this.text, execution) : this.getStringFromField(this.getExpression(execution, this.textVar), execution);
            String htmlStr = this.htmlVar == null ? this.getStringFromField(this.html, execution) : this.getStringFromField(this.getExpression(execution, this.htmlVar), execution);
            String charSetStr = this.getStringFromField(this.charset, execution);
            LinkedList<File> files = new LinkedList<File>();
            LinkedList<DataSource> dataSources = new LinkedList<DataSource>();
            this.getFilesFromFields(this.attachments, execution, files, dataSources);
            email = this.createEmail(textStr, htmlStr, this.attachmentsExist(files, dataSources));
            this.addTo(email, toStr);
            this.setFrom(email, fromStr, execution.getTenantId());
            this.addCc(email, ccStr);
            this.addBcc(email, bccStr);
            this.setSubject(email, subjectStr);
            this.setMailServerProperties(email, execution.getTenantId());
            this.setCharset(email, charSetStr);
            this.attach(email, files, dataSources);
            email.send();
        }
        catch (FlowableException e) {
            this.handleException(execution, e.getMessage(), (Exception)((Object)e), doIgnoreException, exceptionVariable);
        }
        catch (EmailException e) {
            this.handleException(execution, "Could not send e-mail in execution " + execution.getId(), (Exception)((Object)e), doIgnoreException, exceptionVariable);
        }
        this.leave(execution);
    }

    private boolean attachmentsExist(List<File> files, List<DataSource> dataSources) {
        return files != null && !files.isEmpty() || dataSources != null && !dataSources.isEmpty();
    }

    protected Email createEmail(String text, String html, boolean attachmentsExist) {
        if (html != null) {
            return this.createHtmlEmail(text, html);
        }
        if (text != null) {
            if (!attachmentsExist) {
                return this.createTextOnlyEmail(text);
            }
            return this.createMultiPartEmail(text);
        }
        throw new FlowableIllegalArgumentException("'html' or 'text' is required to be defined when using the mail activity");
    }

    protected HtmlEmail createHtmlEmail(String text, String html) {
        HtmlEmail email = new HtmlEmail();
        try {
            email.setHtmlMsg(html);
            if (text != null) {
                email.setTextMsg(text);
            }
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create HTML email", (Throwable)e);
        }
    }

    protected SimpleEmail createTextOnlyEmail(String text) {
        SimpleEmail email = new SimpleEmail();
        try {
            email.setMsg(text);
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create text-only email", (Throwable)e);
        }
    }

    protected MultiPartEmail createMultiPartEmail(String text) {
        MultiPartEmail email = new MultiPartEmail();
        try {
            email.setMsg(text);
            return email;
        }
        catch (EmailException e) {
            throw new FlowableException("Could not create text-only email", (Throwable)e);
        }
    }

    protected void addTo(Email email, String to) {
        String[] tos = this.splitAndTrim(to);
        if (tos != null) {
            for (String t : tos) {
                try {
                    email.addTo(t);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + t + " as recipient", (Throwable)e);
                }
            }
        } else {
            throw new FlowableException("No recipient could be found for sending email");
        }
    }

    protected void setFrom(Email email, String from, String tenantId) {
        String fromAddress = null;
        if (from != null) {
            fromAddress = from;
        } else {
            Map<String, MailServerInfo> mailServers;
            if (tenantId != null && tenantId.length() > 0 && (mailServers = Context.getProcessEngineConfiguration().getMailServers()) != null && mailServers.containsKey(tenantId)) {
                MailServerInfo mailServerInfo = mailServers.get(tenantId);
                fromAddress = mailServerInfo.getMailServerDefaultFrom();
            }
            if (fromAddress == null) {
                fromAddress = Context.getProcessEngineConfiguration().getMailServerDefaultFrom();
            }
        }
        try {
            email.setFrom(fromAddress);
        }
        catch (EmailException e) {
            throw new FlowableException("Could not set " + from + " as from address in email", (Throwable)e);
        }
    }

    protected void addCc(Email email, String cc) {
        String[] ccs = this.splitAndTrim(cc);
        if (ccs != null) {
            for (String c : ccs) {
                try {
                    email.addCc(c);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + c + " as cc recipient", (Throwable)e);
                }
            }
        }
    }

    protected void addBcc(Email email, String bcc) {
        String[] bccs = this.splitAndTrim(bcc);
        if (bccs != null) {
            for (String b : bccs) {
                try {
                    email.addBcc(b);
                }
                catch (EmailException e) {
                    throw new FlowableException("Could not add " + b + " as bcc recipient", (Throwable)e);
                }
            }
        }
    }

    protected void attach(Email email, List<File> files, List<DataSource> dataSources) throws EmailException {
        if (!(email instanceof MultiPartEmail) || !this.attachmentsExist(files, dataSources)) {
            return;
        }
        MultiPartEmail mpEmail = (MultiPartEmail)email;
        for (File file : files) {
            mpEmail.attach(file);
        }
        for (DataSource ds : dataSources) {
            if (ds == null) continue;
            mpEmail.attach(ds, ds.getName(), null);
        }
    }

    protected void setSubject(Email email, String subject) {
        email.setSubject(subject != null ? subject : "");
    }

    protected void setMailServerProperties(Email email, String tenantId) {
        String host;
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        boolean isMailServerSet = false;
        if (tenantId != null && tenantId.length() > 0) {
            if (processEngineConfiguration.getMailSessionJndi(tenantId) != null) {
                this.setEmailSession(email, processEngineConfiguration.getMailSessionJndi(tenantId));
                isMailServerSet = true;
            } else if (processEngineConfiguration.getMailServer(tenantId) != null) {
                MailServerInfo mailServerInfo = processEngineConfiguration.getMailServer(tenantId);
                host = mailServerInfo.getMailServerHost();
                if (host == null) {
                    throw new FlowableException("Could not send email: no SMTP host is configured for tenantId " + tenantId);
                }
                email.setHostName(host);
                email.setSmtpPort(mailServerInfo.getMailServerPort());
                email.setSSLOnConnect(mailServerInfo.isMailServerUseSSL());
                email.setStartTLSEnabled(mailServerInfo.isMailServerUseTLS());
                String user = mailServerInfo.getMailServerUsername();
                String password = mailServerInfo.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }
                isMailServerSet = true;
            }
        }
        if (!isMailServerSet) {
            String mailSessionJndi = processEngineConfiguration.getMailSessionJndi();
            if (mailSessionJndi != null) {
                this.setEmailSession(email, mailSessionJndi);
            } else {
                host = processEngineConfiguration.getMailServerHost();
                if (host == null) {
                    throw new FlowableException("Could not send email: no SMTP host is configured");
                }
                email.setHostName(host);
                int port = processEngineConfiguration.getMailServerPort();
                email.setSmtpPort(port);
                email.setSSLOnConnect(processEngineConfiguration.getMailServerUseSSL());
                email.setStartTLSEnabled(processEngineConfiguration.getMailServerUseTLS());
                String user = processEngineConfiguration.getMailServerUsername();
                String password = processEngineConfiguration.getMailServerPassword();
                if (user != null && password != null) {
                    email.setAuthentication(user, password);
                }
            }
        }
    }

    protected void setEmailSession(Email email, String mailSessionJndi) {
        try {
            email.setMailSessionFromJNDI(mailSessionJndi);
        }
        catch (NamingException e) {
            throw new FlowableException("Could not send email: Incorrect JNDI configuration", (Throwable)e);
        }
    }

    protected void setCharset(Email email, String charSetStr) {
        if (this.charset != null) {
            email.setCharset(charSetStr);
        }
    }

    protected String[] splitAndTrim(String str) {
        if (str != null) {
            String[] splittedStrings = str.split(",");
            for (int i = 0; i < splittedStrings.length; ++i) {
                splittedStrings[i] = splittedStrings[i].trim();
            }
            return splittedStrings;
        }
        return null;
    }

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue(execution)) != null) {
            return value.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void getFilesFromFields(Expression expression, DelegateExecution execution, List<File> files, List<DataSource> dataSources) {
        Object value = this.checkAllowedTypes(expression, execution);
        if (value != null) {
            if (value instanceof File) {
                files.add((File)value);
            } else if (value instanceof String) {
                files.add(new File((String)value));
            } else if (value instanceof File[]) {
                Collections.addAll(files, (File[])value);
            } else if (value instanceof String[]) {
                void var9_11;
                String[] paths;
                String[] stringArray = paths = (String[])value;
                int n = stringArray.length;
                boolean bl = false;
                while (var9_11 < n) {
                    String path = stringArray[var9_11];
                    files.add(new File(path));
                    ++var9_11;
                }
            } else if (value instanceof DataSource) {
                dataSources.add((DataSource)value);
            } else if (value instanceof DataSource[]) {
                for (String string : (DataSource[])value) {
                    if (string == null) continue;
                    dataSources.add((DataSource)string);
                }
            }
        }
        Iterator<File> it = files.iterator();
        while (it.hasNext()) {
            File file = it.next();
            if (this.fileExists(file)) continue;
            it.remove();
        }
    }

    private Object checkAllowedTypes(Expression expression, DelegateExecution execution) {
        if (expression == null) {
            return null;
        }
        Object value = expression.getValue(execution);
        if (value == null) {
            return null;
        }
        for (Class<?> allowedType : ALLOWED_ATT_TYPES) {
            if (!allowedType.isInstance(value)) continue;
            return value;
        }
        throw new FlowableException("Invalid attachment type: " + value.getClass());
    }

    protected boolean fileExists(File file) {
        return file != null && file.exists() && file.isFile() && file.canRead();
    }

    protected Expression getExpression(DelegateExecution execution, Expression var) {
        String variable = (String)execution.getVariable(var.getExpressionText());
        return Context.getProcessEngineConfiguration().getExpressionManager().createExpression(variable);
    }

    protected void handleException(DelegateExecution execution, String msg, Exception e, boolean doIgnoreException, String exceptionVariable) {
        if (doIgnoreException) {
            LOG.info("Ignoring email send error: {}", (Object)msg, (Object)e);
            if (exceptionVariable != null && exceptionVariable.length() > 0) {
                execution.setVariable(exceptionVariable, msg);
            }
        } else {
            if (e instanceof FlowableException) {
                throw (FlowableException)((Object)e);
            }
            throw new FlowableException(msg, (Throwable)e);
        }
    }
}

