/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.impl.asyncexecutor.JobManager;
import org.flowable.engine.impl.cmd.CancelJobsCmd;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.TimerJobEntity;

public class TimerManager {
    protected void removeObsoleteTimers(ProcessDefinitionEntity processDefinition) {
        List<TimerJobEntity> jobsToDelete = null;
        jobsToDelete = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? Context.getCommandContext().getTimerJobEntityManager().findJobsByTypeAndProcessDefinitionKeyAndTenantId("timer-start-event", processDefinition.getKey(), processDefinition.getTenantId()) : Context.getCommandContext().getTimerJobEntityManager().findJobsByTypeAndProcessDefinitionKeyNoTenantId("timer-start-event", processDefinition.getKey());
        if (jobsToDelete != null) {
            for (TimerJobEntity job : jobsToDelete) {
                new CancelJobsCmd(job.getId()).execute(Context.getCommandContext());
            }
        }
    }

    protected void scheduleTimers(ProcessDefinitionEntity processDefinition, Process process) {
        JobManager jobManager = Context.getCommandContext().getJobManager();
        List<TimerJobEntity> timers = this.getTimerDeclarations(processDefinition, process);
        for (TimerJobEntity timer : timers) {
            jobManager.scheduleTimerJob(timer);
        }
    }

    protected List<TimerJobEntity> getTimerDeclarations(ProcessDefinitionEntity processDefinition, Process process) {
        JobManager jobManager = Context.getCommandContext().getJobManager();
        ArrayList<TimerJobEntity> timers = new ArrayList<TimerJobEntity>();
        if (CollectionUtil.isNotEmpty((Collection)process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                TimerEventDefinition timerEventDefinition;
                TimerJobEntity timerJob;
                EventDefinition eventDefinition;
                StartEvent startEvent;
                if (!(element instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)element).getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition) || (timerJob = jobManager.createTimerJob(timerEventDefinition = (TimerEventDefinition)eventDefinition, false, null, "timer-start-event", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()))) == null) continue;
                timerJob.setProcessDefinitionId(processDefinition.getId());
                if (processDefinition.getTenantId() != null) {
                    timerJob.setTenantId(processDefinition.getTenantId());
                }
                timers.add(timerJob);
            }
        }
        return timers;
    }
}

