/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.identity.Authentication;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.task.Comment;
import org.flowable.engine.task.Task;

public class AddCommentCmd
implements Command<Comment> {
    protected String taskId;
    protected String processInstanceId;
    protected String type;
    protected String message;

    public AddCommentCmd(String taskId, String processInstanceId, String message) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.message = message;
    }

    public AddCommentCmd(String taskId, String processInstanceId, String type, String message) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.type = type;
        this.message = message;
    }

    @Override
    public Comment execute(CommandContext commandContext) {
        TaskEntity task = null;
        if (this.taskId != null) {
            task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
            if (task == null) {
                throw new FlowableObjectNotFoundException("Cannot find task with id " + this.taskId, Task.class);
            }
            if (task.isSuspended()) {
                throw new FlowableException(this.getSuspendedTaskException());
            }
        }
        DelegateExecution execution = null;
        if (this.processInstanceId != null) {
            execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
            if (execution == null) {
                throw new FlowableObjectNotFoundException("execution " + this.processInstanceId + " doesn't exist", Execution.class);
            }
            if (execution.isSuspended()) {
                throw new FlowableException(this.getSuspendedExceptionMessage());
            }
        }
        String processDefinitionId = null;
        if (execution != null) {
            processDefinitionId = execution.getProcessDefinitionId();
        } else if (task != null) {
            processDefinitionId = task.getProcessDefinitionId();
        }
        if (processDefinitionId != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, processDefinitionId)) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return compatibilityHandler.addComment(this.taskId, this.processInstanceId, this.type, this.message);
        }
        String userId = Authentication.getAuthenticatedUserId();
        CommentEntity comment = (CommentEntity)commandContext.getCommentEntityManager().create();
        comment.setUserId(userId);
        comment.setType(this.type == null ? "comment" : this.type);
        comment.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        comment.setTaskId(this.taskId);
        comment.setProcessInstanceId(this.processInstanceId);
        comment.setAction("AddComment");
        String eventMessage = this.message.replaceAll("\\s+", " ");
        if (eventMessage.length() > 163) {
            eventMessage = eventMessage.substring(0, 160) + "...";
        }
        comment.setMessage(eventMessage);
        comment.setFullMessage(this.message);
        commandContext.getCommentEntityManager().insert(comment);
        return comment;
    }

    protected String getSuspendedTaskException() {
        return "Cannot add a comment to a suspended task";
    }

    protected String getSuspendedExceptionMessage() {
        return "Cannot add a comment to a suspended execution";
    }
}

