/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.JobNotFoundException;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.jobexecutor.FailedJobListener;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExecuteJobCmd.class);
    protected String jobId;

    public ExecuteJobCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        Job job = (Job)commandContext.getJobEntityManager().findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing job {}", (Object)job.getId());
        }
        if (job.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, job.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.executeJob(job);
            return null;
        }
        commandContext.addCloseListener(new FailedJobListener(commandContext.getProcessEngineConfiguration().getCommandExecutor(), job));
        try {
            commandContext.getJobManager().execute(job);
        }
        catch (Throwable exception) {
            throw new FlowableException("Job " + this.jobId + " failed", exception);
        }
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }
}

